@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.GetPipelinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPipeline.
 * @property pipelineId ID of the pipeline.
 * @property tags Map of tags assigned to the resource.
 */
public data class GetPipelinePlainArgs(
    public val pipelineId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.GetPipelinePlainArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.inputs.GetPipelinePlainArgs =
        com.pulumi.aws.datapipeline.inputs.GetPipelinePlainArgs.builder()
            .pipelineId(pipelineId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPipelinePlainArgs].
 */
@PulumiTagMarker
public class GetPipelinePlainArgsBuilder internal constructor() {
    private var pipelineId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the pipeline.
     */
    @JvmName("bmayidqjmfruvmdn")
    public suspend fun pipelineId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineId = mapped
    }

    /**
     * @param value Map of tags assigned to the resource.
     */
    @JvmName("dieufgkunhkhkbyu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the resource.
     */
    @JvmName("sxbaxkrvjuypvepo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPipelinePlainArgs = GetPipelinePlainArgs(
        pipelineId = pipelineId ?: throw PulumiNullFieldException("pipelineId"),
        tags = tags,
    )
}
