@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id ID of the parameter value.
 * @property stringValue Field value, expressed as a String.
 */
public data class PipelineDefinitionParameterValueArgs(
    public val id: Output<String>,
    public val stringValue: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterValueArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterValueArgs =
        com.pulumi.aws.datapipeline.inputs.PipelineDefinitionParameterValueArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .stringValue(stringValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineDefinitionParameterValueArgs].
 */
@PulumiTagMarker
public class PipelineDefinitionParameterValueArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var stringValue: Output<String>? = null

    /**
     * @param value ID of the parameter value.
     */
    @JvmName("sjnlbvltfflsmcvd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Field value, expressed as a String.
     */
    @JvmName("lhyyykvoidwwxffj")
    public suspend fun stringValue(`value`: Output<String>) {
        this.stringValue = value
    }

    /**
     * @param value ID of the parameter value.
     */
    @JvmName("rdopaxuvfkegueeu")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Field value, expressed as a String.
     */
    @JvmName("tursidjhjbifbcrj")
    public suspend fun stringValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringValue = mapped
    }

    internal fun build(): PipelineDefinitionParameterValueArgs = PipelineDefinitionParameterValueArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        stringValue = stringValue ?: throw PulumiNullFieldException("stringValue"),
    )
}
