@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fields Configuration block for Key-value pairs that define the properties of the object. See below
 * @property id ID of the object.
 * @property name ARN of the storage connector.
 */
public data class PipelineDefinitionPipelineObjectArgs(
    public val fields: Output<List<PipelineDefinitionPipelineObjectFieldArgs>>? = null,
    public val id: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectArgs =
        com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectArgs.builder()
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineDefinitionPipelineObjectArgs].
 */
@PulumiTagMarker
public class PipelineDefinitionPipelineObjectArgsBuilder internal constructor() {
    private var fields: Output<List<PipelineDefinitionPipelineObjectFieldArgs>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Configuration block for Key-value pairs that define the properties of the object. See below
     */
    @JvmName("hicsaxockliaispd")
    public suspend fun fields(`value`: Output<List<PipelineDefinitionPipelineObjectFieldArgs>>) {
        this.fields = value
    }

    @JvmName("ruemawcbvtirbbmh")
    public suspend fun fields(vararg values: Output<PipelineDefinitionPipelineObjectFieldArgs>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for Key-value pairs that define the properties of the object. See below
     */
    @JvmName("gnaushgiovwfqgsr")
    public suspend fun fields(values: List<Output<PipelineDefinitionPipelineObjectFieldArgs>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value ID of the object.
     */
    @JvmName("tdpopsbnqknivomp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value ARN of the storage connector.
     */
    @JvmName("crdvtbuqveiluidg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for Key-value pairs that define the properties of the object. See below
     */
    @JvmName("qhixoaqfimdcxwwg")
    public suspend fun fields(`value`: List<PipelineDefinitionPipelineObjectFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param argument Configuration block for Key-value pairs that define the properties of the object. See below
     */
    @JvmName("iwnvpjnwikxhhigc")
    public suspend fun fields(argument: List<suspend PipelineDefinitionPipelineObjectFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionPipelineObjectFieldArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument Configuration block for Key-value pairs that define the properties of the object. See below
     */
    @JvmName("xanwqgjntkwmurow")
    public suspend fun fields(vararg argument: suspend PipelineDefinitionPipelineObjectFieldArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionPipelineObjectFieldArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param argument Configuration block for Key-value pairs that define the properties of the object. See below
     */
    @JvmName("ldjlnumyxdiigkle")
    public suspend fun fields(argument: suspend PipelineDefinitionPipelineObjectFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionPipelineObjectFieldArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fields = mapped
    }

    /**
     * @param values Configuration block for Key-value pairs that define the properties of the object. See below
     */
    @JvmName("dtoodtamllyoxiag")
    public suspend fun fields(vararg values: PipelineDefinitionPipelineObjectFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value ID of the object.
     */
    @JvmName("rjvswqnfadxltxld")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value ARN of the storage connector.
     */
    @JvmName("hxnxxjwjtfksmxil")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PipelineDefinitionPipelineObjectArgs = PipelineDefinitionPipelineObjectArgs(
        fields = fields,
        id = id ?: throw PulumiNullFieldException("id"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
