@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectFieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Field identifier.
 * @property refValue Field value, expressed as the identifier of another object
 * @property stringValue Field value, expressed as a String.
 */
public data class PipelineDefinitionPipelineObjectFieldArgs(
    public val key: Output<String>,
    public val refValue: Output<String>? = null,
    public val stringValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectFieldArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectFieldArgs =
        com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectFieldArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .refValue(refValue?.applyValue({ args0 -> args0 }))
            .stringValue(stringValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineDefinitionPipelineObjectFieldArgs].
 */
@PulumiTagMarker
public class PipelineDefinitionPipelineObjectFieldArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var refValue: Output<String>? = null

    private var stringValue: Output<String>? = null

    /**
     * @param value Field identifier.
     */
    @JvmName("icaufeuvybwlwgst")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Field value, expressed as the identifier of another object
     */
    @JvmName("mowekjueoqkdwqbn")
    public suspend fun refValue(`value`: Output<String>) {
        this.refValue = value
    }

    /**
     * @param value Field value, expressed as a String.
     */
    @JvmName("tewtvramgnccxnjr")
    public suspend fun stringValue(`value`: Output<String>) {
        this.stringValue = value
    }

    /**
     * @param value Field identifier.
     */
    @JvmName("nqvimhoxpuksnwkm")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Field value, expressed as the identifier of another object
     */
    @JvmName("cqlpyvrjbcdeuoug")
    public suspend fun refValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refValue = mapped
    }

    /**
     * @param value Field value, expressed as a String.
     */
    @JvmName("ginstvojnydabvbl")
    public suspend fun stringValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringValue = mapped
    }

    internal fun build(): PipelineDefinitionPipelineObjectFieldArgs =
        PipelineDefinitionPipelineObjectFieldArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            refValue = refValue,
            stringValue = stringValue,
        )
}
