@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attributes Configuration block for attributes of the parameter object. See below
 * @property id ID of the parameter object.
 */
public data class PipelineDefinitionParameterObject(
    public val attributes: List<PipelineDefinitionParameterObjectAttribute>? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datapipeline.outputs.PipelineDefinitionParameterObject): PipelineDefinitionParameterObject = PipelineDefinitionParameterObject(
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.datapipeline.kotlin.outputs.PipelineDefinitionParameterObjectAttribute.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
