@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key Field identifier.
 * @property refValue Field value, expressed as the identifier of another object
 * @property stringValue Field value, expressed as a String.
 */
public data class PipelineDefinitionPipelineObjectField(
    public val key: String,
    public val refValue: String? = null,
    public val stringValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datapipeline.outputs.PipelineDefinitionPipelineObjectField): PipelineDefinitionPipelineObjectField = PipelineDefinitionPipelineObjectField(
            key = javaType.key(),
            refValue = javaType.refValue().map({ args0 -> args0 }).orElse(null),
            stringValue = javaType.stringValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
