@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.FsxOpenZfsFileSystemProtocol
import com.pulumi.aws.datasync.kotlin.outputs.FsxOpenZfsFileSystemProtocol.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [FsxOpenZfsFileSystem].
 */
@PulumiTagMarker
public class FsxOpenZfsFileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FsxOpenZfsFileSystemArgs = FsxOpenZfsFileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FsxOpenZfsFileSystemArgsBuilder.() -> Unit) {
        val builder = FsxOpenZfsFileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FsxOpenZfsFileSystem {
        val builtJavaResource = com.pulumi.aws.datasync.FsxOpenZfsFileSystem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FsxOpenZfsFileSystem(builtJavaResource)
    }
}

/**
 * Manages an AWS DataSync FSx OpenZfs Location.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.FsxOpenZfsFileSystem("example", {
 *     fsxFilesystemArn: exampleAwsFsxOpenzfsFileSystem.arn,
 *     securityGroupArns: [exampleAwsSecurityGroup&#46;arn],
 *     protocol: {
 *         nfs: {
 *             mountOptions: {
 *                 version: "AUTOMATIC",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.FsxOpenZfsFileSystem("example",
 *     fsx_filesystem_arn=example_aws_fsx_openzfs_file_system["arn"],
 *     security_group_arns=[example_aws_security_group["arn"]],
 *     protocol={
 *         "nfs": {
 *             "mount_options": {
 *                 "version": "AUTOMATIC",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.FsxOpenZfsFileSystem("example", new()
 *     {
 *         FsxFilesystemArn = exampleAwsFsxOpenzfsFileSystem.Arn,
 *         SecurityGroupArns = new[]
 *         {
 *             exampleAwsSecurityGroup.Arn,
 *         },
 *         Protocol = new Aws.DataSync.Inputs.FsxOpenZfsFileSystemProtocolArgs
 *         {
 *             Nfs = new Aws.DataSync.Inputs.FsxOpenZfsFileSystemProtocolNfsArgs
 *             {
 *                 MountOptions = new Aws.DataSync.Inputs.FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs
 *                 {
 *                     Version = "AUTOMATIC",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewFsxOpenZfsFileSystem(ctx, "example", &datasync.FsxOpenZfsFileSystemArgs{
 * 			FsxFilesystemArn: pulumi.Any(exampleAwsFsxOpenzfsFileSystem.Arn),
 * 			SecurityGroupArns: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Arn,
 * 			},
 * 			Protocol: &datasync.FsxOpenZfsFileSystemProtocolArgs{
 * 				Nfs: &datasync.FsxOpenZfsFileSystemProtocolNfsArgs{
 * 					MountOptions: &datasync.FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs{
 * 						Version: pulumi.String("AUTOMATIC"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.FsxOpenZfsFileSystem;
 * import com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FsxOpenZfsFileSystem("example", FsxOpenZfsFileSystemArgs.builder()
 *             .fsxFilesystemArn(exampleAwsFsxOpenzfsFileSystem.arn())
 *             .securityGroupArns(exampleAwsSecurityGroup.arn())
 *             .protocol(FsxOpenZfsFileSystemProtocolArgs.builder()
 *                 .nfs(FsxOpenZfsFileSystemProtocolNfsArgs.builder()
 *                     .mountOptions(FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs.builder()
 *                         .version("AUTOMATIC")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:FsxOpenZfsFileSystem
 *     properties:
 *       fsxFilesystemArn: ${exampleAwsFsxOpenzfsFileSystem.arn}
 *       securityGroupArns:
 *         - ${exampleAwsSecurityGroup.arn}
 *       protocol:
 *         nfs:
 *           mountOptions:
 *             version: AUTOMATIC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_openzfs_file_system` using the `DataSync-ARN#FSx-openzfs-ARN`. For example:
 * ```sh
 * $ pulumi import aws:datasync/fsxOpenZfsFileSystem:FsxOpenZfsFileSystem example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:123456789012:file-system/fs-08e04cd442c1bb94a
 * ```
 */
public class FsxOpenZfsFileSystem internal constructor(
    override val javaResource: com.pulumi.aws.datasync.FsxOpenZfsFileSystem,
) : KotlinCustomResource(javaResource, FsxOpenZfsFileSystemMapper) {
    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The time that the FSx for openzfs location was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the FSx for OpenZfs file system.
     */
    public val fsxFilesystemArn: Output<String>
        get() = javaResource.fsxFilesystemArn().applyValue({ args0 -> args0 })

    /**
     * The type of protocol that DataSync uses to access your file system. See below.
     */
    public val protocol: Output<FsxOpenZfsFileSystemProtocol>
        get() = javaResource.protocol().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
     */
    public val securityGroupArns: Output<List<String>>
        get() = javaResource.securityGroupArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Subdirectory to perform actions as source or destination. Must start with `/fsx`.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The URL of the FSx for openzfs location that was described.
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object FsxOpenZfsFileSystemMapper : ResourceMapper<FsxOpenZfsFileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.FsxOpenZfsFileSystem::class == javaResource::class

    override fun map(javaResource: Resource): FsxOpenZfsFileSystem = FsxOpenZfsFileSystem(
        javaResource
            as com.pulumi.aws.datasync.FsxOpenZfsFileSystem,
    )
}

/**
 * @see [FsxOpenZfsFileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FsxOpenZfsFileSystem].
 */
public suspend fun fsxOpenZfsFileSystem(
    name: String,
    block: suspend FsxOpenZfsFileSystemResourceBuilder.() -> Unit,
): FsxOpenZfsFileSystem {
    val builder = FsxOpenZfsFileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FsxOpenZfsFileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fsxOpenZfsFileSystem(name: String): FsxOpenZfsFileSystem {
    val builder = FsxOpenZfsFileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
