@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.FsxOpenZfsFileSystemProtocolArgs
import com.pulumi.aws.datasync.kotlin.inputs.FsxOpenZfsFileSystemProtocolArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS DataSync FSx OpenZfs Location.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.FsxOpenZfsFileSystem("example", {
 *     fsxFilesystemArn: exampleAwsFsxOpenzfsFileSystem.arn,
 *     securityGroupArns: [exampleAwsSecurityGroup&#46;arn],
 *     protocol: {
 *         nfs: {
 *             mountOptions: {
 *                 version: "AUTOMATIC",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.FsxOpenZfsFileSystem("example",
 *     fsx_filesystem_arn=example_aws_fsx_openzfs_file_system["arn"],
 *     security_group_arns=[example_aws_security_group["arn"]],
 *     protocol={
 *         "nfs": {
 *             "mount_options": {
 *                 "version": "AUTOMATIC",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.FsxOpenZfsFileSystem("example", new()
 *     {
 *         FsxFilesystemArn = exampleAwsFsxOpenzfsFileSystem.Arn,
 *         SecurityGroupArns = new[]
 *         {
 *             exampleAwsSecurityGroup.Arn,
 *         },
 *         Protocol = new Aws.DataSync.Inputs.FsxOpenZfsFileSystemProtocolArgs
 *         {
 *             Nfs = new Aws.DataSync.Inputs.FsxOpenZfsFileSystemProtocolNfsArgs
 *             {
 *                 MountOptions = new Aws.DataSync.Inputs.FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs
 *                 {
 *                     Version = "AUTOMATIC",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewFsxOpenZfsFileSystem(ctx, "example", &datasync.FsxOpenZfsFileSystemArgs{
 * 			FsxFilesystemArn: pulumi.Any(exampleAwsFsxOpenzfsFileSystem.Arn),
 * 			SecurityGroupArns: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Arn,
 * 			},
 * 			Protocol: &datasync.FsxOpenZfsFileSystemProtocolArgs{
 * 				Nfs: &datasync.FsxOpenZfsFileSystemProtocolNfsArgs{
 * 					MountOptions: &datasync.FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs{
 * 						Version: pulumi.String("AUTOMATIC"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.FsxOpenZfsFileSystem;
 * import com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsArgs;
 * import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FsxOpenZfsFileSystem("example", FsxOpenZfsFileSystemArgs.builder()
 *             .fsxFilesystemArn(exampleAwsFsxOpenzfsFileSystem.arn())
 *             .securityGroupArns(exampleAwsSecurityGroup.arn())
 *             .protocol(FsxOpenZfsFileSystemProtocolArgs.builder()
 *                 .nfs(FsxOpenZfsFileSystemProtocolNfsArgs.builder()
 *                     .mountOptions(FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs.builder()
 *                         .version("AUTOMATIC")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:FsxOpenZfsFileSystem
 *     properties:
 *       fsxFilesystemArn: ${exampleAwsFsxOpenzfsFileSystem.arn}
 *       securityGroupArns:
 *         - ${exampleAwsSecurityGroup.arn}
 *       protocol:
 *         nfs:
 *           mountOptions:
 *             version: AUTOMATIC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_openzfs_file_system` using the `DataSync-ARN#FSx-openzfs-ARN`. For example:
 * ```sh
 * $ pulumi import aws:datasync/fsxOpenZfsFileSystem:FsxOpenZfsFileSystem example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:123456789012:file-system/fs-08e04cd442c1bb94a
 * ```
 * @property fsxFilesystemArn The Amazon Resource Name (ARN) for the FSx for OpenZfs file system.
 * @property protocol The type of protocol that DataSync uses to access your file system. See below.
 * @property securityGroupArns The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
 * @property subdirectory Subdirectory to perform actions as source or destination. Must start with `/fsx`.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FsxOpenZfsFileSystemArgs(
    public val fsxFilesystemArn: Output<String>? = null,
    public val protocol: Output<FsxOpenZfsFileSystemProtocolArgs>? = null,
    public val securityGroupArns: Output<List<String>>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs =
        com.pulumi.aws.datasync.FsxOpenZfsFileSystemArgs.builder()
            .fsxFilesystemArn(fsxFilesystemArn?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityGroupArns(securityGroupArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FsxOpenZfsFileSystemArgs].
 */
@PulumiTagMarker
public class FsxOpenZfsFileSystemArgsBuilder internal constructor() {
    private var fsxFilesystemArn: Output<String>? = null

    private var protocol: Output<FsxOpenZfsFileSystemProtocolArgs>? = null

    private var securityGroupArns: Output<List<String>>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) for the FSx for OpenZfs file system.
     */
    @JvmName("pkkwwdqnluecqytl")
    public suspend fun fsxFilesystemArn(`value`: Output<String>) {
        this.fsxFilesystemArn = value
    }

    /**
     * @param value The type of protocol that DataSync uses to access your file system. See below.
     */
    @JvmName("tbtmteyvdcgggcqw")
    public suspend fun protocol(`value`: Output<FsxOpenZfsFileSystemProtocolArgs>) {
        this.protocol = value
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
     */
    @JvmName("eyaeijbpvqinymxl")
    public suspend fun securityGroupArns(`value`: Output<List<String>>) {
        this.securityGroupArns = value
    }

    @JvmName("irrslupepmjyxtpy")
    public suspend fun securityGroupArns(vararg values: Output<String>) {
        this.securityGroupArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
     */
    @JvmName("tgyfxbgknxoqdjgb")
    public suspend fun securityGroupArns(values: List<Output<String>>) {
        this.securityGroupArns = Output.all(values)
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Must start with `/fsx`.
     */
    @JvmName("wxlplnopbyipaxvl")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kpwnhekygjtbjtic")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the FSx for OpenZfs file system.
     */
    @JvmName("wjvdgwlasrjsmmxb")
    public suspend fun fsxFilesystemArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsxFilesystemArn = mapped
    }

    /**
     * @param value The type of protocol that DataSync uses to access your file system. See below.
     */
    @JvmName("vydnedjngkngcsoe")
    public suspend fun protocol(`value`: FsxOpenZfsFileSystemProtocolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param argument The type of protocol that DataSync uses to access your file system. See below.
     */
    @JvmName("kryuimurxsomsvme")
    public suspend fun protocol(argument: suspend FsxOpenZfsFileSystemProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = FsxOpenZfsFileSystemProtocolArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protocol = mapped
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
     */
    @JvmName("hkcskuiexflnfsrv")
    public suspend fun securityGroupArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for openzfs file system.
     */
    @JvmName("iyechkyouaffcyum")
    public suspend fun securityGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Must start with `/fsx`.
     */
    @JvmName("ilficaggxubpceum")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xadinmlexbshfrft")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ybrahpmmndviqsmr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FsxOpenZfsFileSystemArgs = FsxOpenZfsFileSystemArgs(
        fsxFilesystemArn = fsxFilesystemArn,
        protocol = protocol,
        securityGroupArns = securityGroupArns,
        subdirectory = subdirectory,
        tags = tags,
    )
}
