@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.LocationAzureBlobSasConfiguration
import com.pulumi.aws.datasync.kotlin.outputs.LocationAzureBlobSasConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LocationAzureBlob].
 */
@PulumiTagMarker
public class LocationAzureBlobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationAzureBlobArgs = LocationAzureBlobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationAzureBlobArgsBuilder.() -> Unit) {
        val builder = LocationAzureBlobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocationAzureBlob {
        val builtJavaResource = com.pulumi.aws.datasync.LocationAzureBlob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocationAzureBlob(builtJavaResource)
    }
}

/**
 * Manages a Microsoft Azure Blob Storage Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationAzureBlob("example", {
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     authenticationType: "SAS",
 *     containerUrl: "https://myaccount.blob.core.windows.net/mycontainer",
 *     sasConfiguration: {
 *         token: "sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationAzureBlob("example",
 *     agent_arns=[example_aws_datasync_agent["arn"]],
 *     authentication_type="SAS",
 *     container_url="https://myaccount.blob.core.windows.net/mycontainer",
 *     sas_configuration={
 *         "token": "sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationAzureBlob("example", new()
 *     {
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *         AuthenticationType = "SAS",
 *         ContainerUrl = "https://myaccount.blob.core.windows.net/mycontainer",
 *         SasConfiguration = new Aws.DataSync.Inputs.LocationAzureBlobSasConfigurationArgs
 *         {
 *             Token = "sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationAzureBlob(ctx, "example", &datasync.LocationAzureBlobArgs{
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 			AuthenticationType: pulumi.String("SAS"),
 * 			ContainerUrl:       pulumi.String("https://myaccount.blob.core.windows.net/mycontainer"),
 * 			SasConfiguration: &datasync.LocationAzureBlobSasConfigurationArgs{
 * 				Token: pulumi.String("sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationAzureBlob;
 * import com.pulumi.aws.datasync.LocationAzureBlobArgs;
 * import com.pulumi.aws.datasync.inputs.LocationAzureBlobSasConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationAzureBlob("example", LocationAzureBlobArgs.builder()
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .authenticationType("SAS")
 *             .containerUrl("https://myaccount.blob.core.windows.net/mycontainer")
 *             .sasConfiguration(LocationAzureBlobSasConfigurationArgs.builder()
 *                 .token("sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationAzureBlob
 *     properties:
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 *       authenticationType: SAS
 *       containerUrl: https://myaccount.blob.core.windows.net/mycontainer
 *       sasConfiguration:
 *         token: sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_azure_blob` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/locationAzureBlob:LocationAzureBlob example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 */
public class LocationAzureBlob internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationAzureBlob,
) : KotlinCustomResource(javaResource, LocationAzureBlobMapper) {
    /**
     * The access tier that you want your objects or files transferred into. Valid values: `HOT`, `COOL` and `ARCHIVE`. Default: `HOT`.
     */
    public val accessTier: Output<String>?
        get() = javaResource.accessTier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     */
    public val agentArns: Output<List<String>>
        get() = javaResource.agentArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The authentication method DataSync uses to access your Azure Blob Storage. Valid values: `SAS`.
     */
    public val authenticationType: Output<String>
        get() = javaResource.authenticationType().applyValue({ args0 -> args0 })

    /**
     * The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Valid values: `BLOB`. Default: `BLOB`.
     */
    public val blobType: Output<String>?
        get() = javaResource.blobType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The URL of the Azure Blob Storage container involved in your transfer.
     */
    public val containerUrl: Output<String>
        get() = javaResource.containerUrl().applyValue({ args0 -> args0 })

    /**
     * The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
     */
    public val sasConfiguration: Output<LocationAzureBlobSasConfiguration>?
        get() = javaResource.sasConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Path segments if you want to limit your transfer to a virtual directory in the container.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object LocationAzureBlobMapper : ResourceMapper<LocationAzureBlob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationAzureBlob::class == javaResource::class

    override fun map(javaResource: Resource): LocationAzureBlob = LocationAzureBlob(
        javaResource as
            com.pulumi.aws.datasync.LocationAzureBlob,
    )
}

/**
 * @see [LocationAzureBlob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationAzureBlob].
 */
public suspend fun locationAzureBlob(
    name: String,
    block: suspend LocationAzureBlobResourceBuilder.() -> Unit,
): LocationAzureBlob {
    val builder = LocationAzureBlobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationAzureBlob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationAzureBlob(name: String): LocationAzureBlob {
    val builder = LocationAzureBlobResourceBuilder()
    builder.name(name)
    return builder.build()
}
