@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationAzureBlobArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.LocationAzureBlobSasConfigurationArgs
import com.pulumi.aws.datasync.kotlin.inputs.LocationAzureBlobSasConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Microsoft Azure Blob Storage Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationAzureBlob("example", {
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     authenticationType: "SAS",
 *     containerUrl: "https://myaccount.blob.core.windows.net/mycontainer",
 *     sasConfiguration: {
 *         token: "sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationAzureBlob("example",
 *     agent_arns=[example_aws_datasync_agent["arn"]],
 *     authentication_type="SAS",
 *     container_url="https://myaccount.blob.core.windows.net/mycontainer",
 *     sas_configuration={
 *         "token": "sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationAzureBlob("example", new()
 *     {
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *         AuthenticationType = "SAS",
 *         ContainerUrl = "https://myaccount.blob.core.windows.net/mycontainer",
 *         SasConfiguration = new Aws.DataSync.Inputs.LocationAzureBlobSasConfigurationArgs
 *         {
 *             Token = "sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationAzureBlob(ctx, "example", &datasync.LocationAzureBlobArgs{
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 			AuthenticationType: pulumi.String("SAS"),
 * 			ContainerUrl:       pulumi.String("https://myaccount.blob.core.windows.net/mycontainer"),
 * 			SasConfiguration: &datasync.LocationAzureBlobSasConfigurationArgs{
 * 				Token: pulumi.String("sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationAzureBlob;
 * import com.pulumi.aws.datasync.LocationAzureBlobArgs;
 * import com.pulumi.aws.datasync.inputs.LocationAzureBlobSasConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationAzureBlob("example", LocationAzureBlobArgs.builder()
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .authenticationType("SAS")
 *             .containerUrl("https://myaccount.blob.core.windows.net/mycontainer")
 *             .sasConfiguration(LocationAzureBlobSasConfigurationArgs.builder()
 *                 .token("sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationAzureBlob
 *     properties:
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 *       authenticationType: SAS
 *       containerUrl: https://myaccount.blob.core.windows.net/mycontainer
 *       sasConfiguration:
 *         token: sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_azure_blob` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/locationAzureBlob:LocationAzureBlob example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property accessTier The access tier that you want your objects or files transferred into. Valid values: `HOT`, `COOL` and `ARCHIVE`. Default: `HOT`.
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property authenticationType The authentication method DataSync uses to access your Azure Blob Storage. Valid values: `SAS`.
 * @property blobType The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Valid values: `BLOB`. Default: `BLOB`.
 * @property containerUrl The URL of the Azure Blob Storage container involved in your transfer.
 * @property sasConfiguration The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
 * @property subdirectory Path segments if you want to limit your transfer to a virtual directory in the container.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LocationAzureBlobArgs(
    public val accessTier: Output<String>? = null,
    public val agentArns: Output<List<String>>? = null,
    public val authenticationType: Output<String>? = null,
    public val blobType: Output<String>? = null,
    public val containerUrl: Output<String>? = null,
    public val sasConfiguration: Output<LocationAzureBlobSasConfigurationArgs>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationAzureBlobArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationAzureBlobArgs =
        com.pulumi.aws.datasync.LocationAzureBlobArgs.builder()
            .accessTier(accessTier?.applyValue({ args0 -> args0 }))
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .blobType(blobType?.applyValue({ args0 -> args0 }))
            .containerUrl(containerUrl?.applyValue({ args0 -> args0 }))
            .sasConfiguration(sasConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocationAzureBlobArgs].
 */
@PulumiTagMarker
public class LocationAzureBlobArgsBuilder internal constructor() {
    private var accessTier: Output<String>? = null

    private var agentArns: Output<List<String>>? = null

    private var authenticationType: Output<String>? = null

    private var blobType: Output<String>? = null

    private var containerUrl: Output<String>? = null

    private var sasConfiguration: Output<LocationAzureBlobSasConfigurationArgs>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The access tier that you want your objects or files transferred into. Valid values: `HOT`, `COOL` and `ARCHIVE`. Default: `HOT`.
     */
    @JvmName("uxcussdvxxchiuyy")
    public suspend fun accessTier(`value`: Output<String>) {
        this.accessTier = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("osrkigqogcfwytic")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("sngdwcowhelepsxi")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("ymjvrakibianpjge")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value The authentication method DataSync uses to access your Azure Blob Storage. Valid values: `SAS`.
     */
    @JvmName("whbxqbsfjpcdsnqk")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Valid values: `BLOB`. Default: `BLOB`.
     */
    @JvmName("xgtiophxcnsclkir")
    public suspend fun blobType(`value`: Output<String>) {
        this.blobType = value
    }

    /**
     * @param value The URL of the Azure Blob Storage container involved in your transfer.
     */
    @JvmName("ewwbjqvqrybjkvjn")
    public suspend fun containerUrl(`value`: Output<String>) {
        this.containerUrl = value
    }

    /**
     * @param value The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
     */
    @JvmName("ukuhlkyxulnfhoed")
    public suspend fun sasConfiguration(`value`: Output<LocationAzureBlobSasConfigurationArgs>) {
        this.sasConfiguration = value
    }

    /**
     * @param value Path segments if you want to limit your transfer to a virtual directory in the container.
     */
    @JvmName("agchyudhesjskqix")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pnatyptuopojrnlv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The access tier that you want your objects or files transferred into. Valid values: `HOT`, `COOL` and `ARCHIVE`. Default: `HOT`.
     */
    @JvmName("ujiolvjrpokwqkcw")
    public suspend fun accessTier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("visjeatfxogjlocy")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("anwlakuuusjcqiqf")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value The authentication method DataSync uses to access your Azure Blob Storage. Valid values: `SAS`.
     */
    @JvmName("ugjsyijkslmnleyb")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type of blob that you want your objects or files to be when transferring them into Azure Blob Storage. Valid values: `BLOB`. Default: `BLOB`.
     */
    @JvmName("ymdrvwlwbsvnmhnc")
    public suspend fun blobType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobType = mapped
    }

    /**
     * @param value The URL of the Azure Blob Storage container involved in your transfer.
     */
    @JvmName("vewggkwuidiruswu")
    public suspend fun containerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerUrl = mapped
    }

    /**
     * @param value The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
     */
    @JvmName("wajvdenfrkklicsb")
    public suspend fun sasConfiguration(`value`: LocationAzureBlobSasConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasConfiguration = mapped
    }

    /**
     * @param argument The SAS configuration that allows DataSync to access your Azure Blob Storage. See configuration below.
     */
    @JvmName("sovdovrjykfyjalh")
    public suspend fun sasConfiguration(argument: suspend LocationAzureBlobSasConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LocationAzureBlobSasConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sasConfiguration = mapped
    }

    /**
     * @param value Path segments if you want to limit your transfer to a virtual directory in the container.
     */
    @JvmName("dkrjnafxkifflvyd")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("edwlpphahkxgdbgi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xietujrcguuoqtew")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocationAzureBlobArgs = LocationAzureBlobArgs(
        accessTier = accessTier,
        agentArns = agentArns,
        authenticationType = authenticationType,
        blobType = blobType,
        containerUrl = containerUrl,
        sasConfiguration = sasConfiguration,
        subdirectory = subdirectory,
        tags = tags,
    )
}
