@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LocationFsxLustre].
 */
@PulumiTagMarker
public class LocationFsxLustreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationFsxLustreArgs = LocationFsxLustreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationFsxLustreArgsBuilder.() -> Unit) {
        val builder = LocationFsxLustreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocationFsxLustre {
        val builtJavaResource = com.pulumi.aws.datasync.LocationFsxLustre(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocationFsxLustre(builtJavaResource)
    }
}

/**
 * Manages an AWS DataSync FSx Lustre Location.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationFsxLustre("example", {
 *     fsxFilesystemArn: exampleAwsFsxLustreFileSystem.arn,
 *     securityGroupArns: [exampleAwsSecurityGroup&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationFsxLustre("example",
 *     fsx_filesystem_arn=example_aws_fsx_lustre_file_system["arn"],
 *     security_group_arns=[example_aws_security_group["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationFsxLustre("example", new()
 *     {
 *         FsxFilesystemArn = exampleAwsFsxLustreFileSystem.Arn,
 *         SecurityGroupArns = new[]
 *         {
 *             exampleAwsSecurityGroup.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationFsxLustre(ctx, "example", &datasync.LocationFsxLustreArgs{
 * 			FsxFilesystemArn: pulumi.Any(exampleAwsFsxLustreFileSystem.Arn),
 * 			SecurityGroupArns: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationFsxLustre;
 * import com.pulumi.aws.datasync.LocationFsxLustreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationFsxLustre("example", LocationFsxLustreArgs.builder()
 *             .fsxFilesystemArn(exampleAwsFsxLustreFileSystem.arn())
 *             .securityGroupArns(exampleAwsSecurityGroup.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationFsxLustre
 *     properties:
 *       fsxFilesystemArn: ${exampleAwsFsxLustreFileSystem.arn}
 *       securityGroupArns:
 *         - ${exampleAwsSecurityGroup.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_lustre_file_system` using the `DataSync-ARN#FSx-Lustre-ARN`. For example:
 * ```sh
 * $ pulumi import aws:datasync/locationFsxLustre:LocationFsxLustre example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:476956259333:file-system/fs-08e04cd442c1bb94a
 * ```
 */
public class LocationFsxLustre internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationFsxLustre,
) : KotlinCustomResource(javaResource, LocationFsxLustreMapper) {
    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The time that the FSx for Lustre location was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the FSx for Lustre file system.
     */
    public val fsxFilesystemArn: Output<String>
        get() = javaResource.fsxFilesystemArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Lustre file system.
     */
    public val securityGroupArns: Output<List<String>>
        get() = javaResource.securityGroupArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Subdirectory to perform actions as source or destination.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The URL of the FSx for Lustre location that was described.
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object LocationFsxLustreMapper : ResourceMapper<LocationFsxLustre> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationFsxLustre::class == javaResource::class

    override fun map(javaResource: Resource): LocationFsxLustre = LocationFsxLustre(
        javaResource as
            com.pulumi.aws.datasync.LocationFsxLustre,
    )
}

/**
 * @see [LocationFsxLustre].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationFsxLustre].
 */
public suspend fun locationFsxLustre(
    name: String,
    block: suspend LocationFsxLustreResourceBuilder.() -> Unit,
): LocationFsxLustre {
    val builder = LocationFsxLustreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationFsxLustre].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationFsxLustre(name: String): LocationFsxLustre {
    val builder = LocationFsxLustreResourceBuilder()
    builder.name(name)
    return builder.build()
}
