@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationFsxLustreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS DataSync FSx Lustre Location.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationFsxLustre("example", {
 *     fsxFilesystemArn: exampleAwsFsxLustreFileSystem.arn,
 *     securityGroupArns: [exampleAwsSecurityGroup&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationFsxLustre("example",
 *     fsx_filesystem_arn=example_aws_fsx_lustre_file_system["arn"],
 *     security_group_arns=[example_aws_security_group["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationFsxLustre("example", new()
 *     {
 *         FsxFilesystemArn = exampleAwsFsxLustreFileSystem.Arn,
 *         SecurityGroupArns = new[]
 *         {
 *             exampleAwsSecurityGroup.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationFsxLustre(ctx, "example", &datasync.LocationFsxLustreArgs{
 * 			FsxFilesystemArn: pulumi.Any(exampleAwsFsxLustreFileSystem.Arn),
 * 			SecurityGroupArns: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationFsxLustre;
 * import com.pulumi.aws.datasync.LocationFsxLustreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationFsxLustre("example", LocationFsxLustreArgs.builder()
 *             .fsxFilesystemArn(exampleAwsFsxLustreFileSystem.arn())
 *             .securityGroupArns(exampleAwsSecurityGroup.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationFsxLustre
 *     properties:
 *       fsxFilesystemArn: ${exampleAwsFsxLustreFileSystem.arn}
 *       securityGroupArns:
 *         - ${exampleAwsSecurityGroup.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_lustre_file_system` using the `DataSync-ARN#FSx-Lustre-ARN`. For example:
 * ```sh
 * $ pulumi import aws:datasync/locationFsxLustre:LocationFsxLustre example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:476956259333:file-system/fs-08e04cd442c1bb94a
 * ```
 * @property fsxFilesystemArn The Amazon Resource Name (ARN) for the FSx for Lustre file system.
 * @property securityGroupArns The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Lustre file system.
 * @property subdirectory Subdirectory to perform actions as source or destination.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LocationFsxLustreArgs(
    public val fsxFilesystemArn: Output<String>? = null,
    public val securityGroupArns: Output<List<String>>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationFsxLustreArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationFsxLustreArgs =
        com.pulumi.aws.datasync.LocationFsxLustreArgs.builder()
            .fsxFilesystemArn(fsxFilesystemArn?.applyValue({ args0 -> args0 }))
            .securityGroupArns(securityGroupArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocationFsxLustreArgs].
 */
@PulumiTagMarker
public class LocationFsxLustreArgsBuilder internal constructor() {
    private var fsxFilesystemArn: Output<String>? = null

    private var securityGroupArns: Output<List<String>>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) for the FSx for Lustre file system.
     */
    @JvmName("mqvguostuvroxotc")
    public suspend fun fsxFilesystemArn(`value`: Output<String>) {
        this.fsxFilesystemArn = value
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Lustre file system.
     */
    @JvmName("abyxoyujgwiaoasi")
    public suspend fun securityGroupArns(`value`: Output<List<String>>) {
        this.securityGroupArns = value
    }

    @JvmName("nnwonpkasrafqrnf")
    public suspend fun securityGroupArns(vararg values: Output<String>) {
        this.securityGroupArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Lustre file system.
     */
    @JvmName("tyrtfshidadhtpvh")
    public suspend fun securityGroupArns(values: List<Output<String>>) {
        this.securityGroupArns = Output.all(values)
    }

    /**
     * @param value Subdirectory to perform actions as source or destination.
     */
    @JvmName("cgihydaipswqxgiq")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wxudeewosuvnfnhk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the FSx for Lustre file system.
     */
    @JvmName("yqqmcsiiqyrjtrjg")
    public suspend fun fsxFilesystemArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsxFilesystemArn = mapped
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Lustre file system.
     */
    @JvmName("yamxffeftnibsjew")
    public suspend fun securityGroupArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Lustre file system.
     */
    @JvmName("jcpjkfepjiwtkkij")
    public suspend fun securityGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param value Subdirectory to perform actions as source or destination.
     */
    @JvmName("pqukviupokscijut")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yixjyxnjupsvogsx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cnsdwspexbdytgdp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocationFsxLustreArgs = LocationFsxLustreArgs(
        fsxFilesystemArn = fsxFilesystemArn,
        securityGroupArns = securityGroupArns,
        subdirectory = subdirectory,
        tags = tags,
    )
}
