@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationFsxOntapFileSystemArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.LocationFsxOntapFileSystemProtocolArgs
import com.pulumi.aws.datasync.kotlin.inputs.LocationFsxOntapFileSystemProtocolArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS DataSync Location FSx Ontap File System.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:datasync:LocationFsxOntapFileSystem
 *     properties:
 *       fsxFilesystemArn: ${testAwsFsxOntapFileSystem.arn}
 *       securityGroupArns:
 *         - ${testAwsSecurityGroup.arn}
 *       storageVirtualMachineArn: ${testAwsFsxOntapStorageVirtualMachine.arn}
 *       protocol:
 *         nfs:
 *           mountOptions:
 *             version: NFS3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_ontap_file_system` using the `DataSync-ARN#FSx-ontap-svm-ARN`. For example:
 * ```sh
 * $ pulumi import aws:datasync/locationFsxOntapFileSystem:LocationFsxOntapFileSystem example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:123456789012:storage-virtual-machine/svm-12345678abcdef123
 * ```
 * @property protocol The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
 * @property securityGroupArns The security groups that provide access to your file system's preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
 * * Network File System (NFS): TCP ports 111, 635, and 2049
 * * Server Message Block (SMB): TCP port 445
 * @property storageVirtualMachineArn The ARN of the SVM in your file system where you want to copy data to of from.
 * The following arguments are optional:
 * @property subdirectory Path to the file share in the SVM where you'll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LocationFsxOntapFileSystemArgs(
    public val protocol: Output<LocationFsxOntapFileSystemProtocolArgs>? = null,
    public val securityGroupArns: Output<List<String>>? = null,
    public val storageVirtualMachineArn: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationFsxOntapFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationFsxOntapFileSystemArgs =
        com.pulumi.aws.datasync.LocationFsxOntapFileSystemArgs.builder()
            .protocol(protocol?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityGroupArns(securityGroupArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageVirtualMachineArn(storageVirtualMachineArn?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocationFsxOntapFileSystemArgs].
 */
@PulumiTagMarker
public class LocationFsxOntapFileSystemArgsBuilder internal constructor() {
    private var protocol: Output<LocationFsxOntapFileSystemProtocolArgs>? = null

    private var securityGroupArns: Output<List<String>>? = null

    private var storageVirtualMachineArn: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     */
    @JvmName("nbkdprpidpndwwwa")
    public suspend fun protocol(`value`: Output<LocationFsxOntapFileSystemProtocolArgs>) {
        this.protocol = value
    }

    /**
     * @param value The security groups that provide access to your file system's preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     */
    @JvmName("qrnyithskjxffncw")
    public suspend fun securityGroupArns(`value`: Output<List<String>>) {
        this.securityGroupArns = value
    }

    @JvmName("smaqxbpddnsugpwd")
    public suspend fun securityGroupArns(vararg values: Output<String>) {
        this.securityGroupArns = Output.all(values.asList())
    }

    /**
     * @param values The security groups that provide access to your file system's preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     */
    @JvmName("yyggovchekgjmolc")
    public suspend fun securityGroupArns(values: List<Output<String>>) {
        this.securityGroupArns = Output.all(values)
    }

    /**
     * @param value The ARN of the SVM in your file system where you want to copy data to of from.
     * The following arguments are optional:
     */
    @JvmName("ysseljvrgnrujtcn")
    public suspend fun storageVirtualMachineArn(`value`: Output<String>) {
        this.storageVirtualMachineArn = value
    }

    /**
     * @param value Path to the file share in the SVM where you'll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
     */
    @JvmName("kjmgesogsfdfetip")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bxtpkhbdjdvnnfjk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     */
    @JvmName("frtfytxhthbyskms")
    public suspend fun protocol(`value`: LocationFsxOntapFileSystemProtocolArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param argument The data transfer protocol that DataSync uses to access your Amazon FSx file system. See Protocol below.
     */
    @JvmName("fwpkdllnjjywpfwy")
    public suspend fun protocol(argument: suspend LocationFsxOntapFileSystemProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = LocationFsxOntapFileSystemProtocolArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.protocol = mapped
    }

    /**
     * @param value The security groups that provide access to your file system's preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     */
    @JvmName("asrhebqixlhxbtkd")
    public suspend fun securityGroupArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param values The security groups that provide access to your file system's preferred subnet. The security groups must allow outbbound traffic on the following ports (depending on the protocol you use):
     * * Network File System (NFS): TCP ports 111, 635, and 2049
     * * Server Message Block (SMB): TCP port 445
     */
    @JvmName("greurdeucanspyhj")
    public suspend fun securityGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param value The ARN of the SVM in your file system where you want to copy data to of from.
     * The following arguments are optional:
     */
    @JvmName("cbaagielnbhxipcd")
    public suspend fun storageVirtualMachineArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageVirtualMachineArn = mapped
    }

    /**
     * @param value Path to the file share in the SVM where you'll copy your data. You can specify a junction path (also known as a mount point), qtree path (for NFS file shares), or share name (for SMB file shares) (e.g. `/vol1`, `/vol1/tree1`, `share1`).
     */
    @JvmName("denaqgcnuyinrdyy")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hestvgxsnxucaprc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ybrtudnhnrdqqdkl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocationFsxOntapFileSystemArgs = LocationFsxOntapFileSystemArgs(
        protocol = protocol,
        securityGroupArns = securityGroupArns,
        storageVirtualMachineArn = storageVirtualMachineArn,
        subdirectory = subdirectory,
        tags = tags,
    )
}
