@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationFsxWindowsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS DataSync FSx Windows Location.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationFsxWindows("example", {
 *     fsxFilesystemArn: exampleAwsFsxWindowsFileSystem.arn,
 *     user: "SomeUser",
 *     password: "SuperSecretPassw0rd",
 *     securityGroupArns: [exampleAwsSecurityGroup&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationFsxWindows("example",
 *     fsx_filesystem_arn=example_aws_fsx_windows_file_system["arn"],
 *     user="SomeUser",
 *     password="SuperSecretPassw0rd",
 *     security_group_arns=[example_aws_security_group["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationFsxWindows("example", new()
 *     {
 *         FsxFilesystemArn = exampleAwsFsxWindowsFileSystem.Arn,
 *         User = "SomeUser",
 *         Password = "SuperSecretPassw0rd",
 *         SecurityGroupArns = new[]
 *         {
 *             exampleAwsSecurityGroup.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationFsxWindows(ctx, "example", &datasync.LocationFsxWindowsArgs{
 * 			FsxFilesystemArn: pulumi.Any(exampleAwsFsxWindowsFileSystem.Arn),
 * 			User:             pulumi.String("SomeUser"),
 * 			Password:         pulumi.String("SuperSecretPassw0rd"),
 * 			SecurityGroupArns: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationFsxWindows;
 * import com.pulumi.aws.datasync.LocationFsxWindowsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationFsxWindows("example", LocationFsxWindowsArgs.builder()
 *             .fsxFilesystemArn(exampleAwsFsxWindowsFileSystem.arn())
 *             .user("SomeUser")
 *             .password("SuperSecretPassw0rd")
 *             .securityGroupArns(exampleAwsSecurityGroup.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationFsxWindows
 *     properties:
 *       fsxFilesystemArn: ${exampleAwsFsxWindowsFileSystem.arn}
 *       user: SomeUser
 *       password: SuperSecretPassw0rd
 *       securityGroupArns:
 *         - ${exampleAwsSecurityGroup.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_fsx_windows_file_system` using the `DataSync-ARN#FSx-Windows-ARN`. For example:
 * ```sh
 * $ pulumi import aws:datasync/locationFsxWindows:LocationFsxWindows example arn:aws:datasync:us-west-2:123456789012:location/loc-12345678901234567#arn:aws:fsx:us-west-2:476956259333:file-system/fs-08e04cd442c1bb94a
 * ```
 * @property domain The name of the Windows domain that the FSx for Windows server belongs to.
 * @property fsxFilesystemArn The Amazon Resource Name (ARN) for the FSx for Windows file system.
 * @property password The password of the user who has the permissions to access files and folders in the FSx for Windows file system.
 * @property securityGroupArns The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Windows file system.
 * @property subdirectory Subdirectory to perform actions as source or destination.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property user The user who has the permissions to access files and folders in the FSx for Windows file system.
 */
public data class LocationFsxWindowsArgs(
    public val domain: Output<String>? = null,
    public val fsxFilesystemArn: Output<String>? = null,
    public val password: Output<String>? = null,
    public val securityGroupArns: Output<List<String>>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationFsxWindowsArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationFsxWindowsArgs =
        com.pulumi.aws.datasync.LocationFsxWindowsArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .fsxFilesystemArn(fsxFilesystemArn?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .securityGroupArns(securityGroupArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationFsxWindowsArgs].
 */
@PulumiTagMarker
public class LocationFsxWindowsArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var fsxFilesystemArn: Output<String>? = null

    private var password: Output<String>? = null

    private var securityGroupArns: Output<List<String>>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var user: Output<String>? = null

    /**
     * @param value The name of the Windows domain that the FSx for Windows server belongs to.
     */
    @JvmName("lvvrbfopodtfsloh")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the FSx for Windows file system.
     */
    @JvmName("xrfdgcfvfbjvxjla")
    public suspend fun fsxFilesystemArn(`value`: Output<String>) {
        this.fsxFilesystemArn = value
    }

    /**
     * @param value The password of the user who has the permissions to access files and folders in the FSx for Windows file system.
     */
    @JvmName("upapujiqcrtwavpk")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Windows file system.
     */
    @JvmName("cusorivatnfxospk")
    public suspend fun securityGroupArns(`value`: Output<List<String>>) {
        this.securityGroupArns = value
    }

    @JvmName("xdahxiuydeegaxbf")
    public suspend fun securityGroupArns(vararg values: Output<String>) {
        this.securityGroupArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Windows file system.
     */
    @JvmName("vskbsavnawsayygd")
    public suspend fun securityGroupArns(values: List<Output<String>>) {
        this.securityGroupArns = Output.all(values)
    }

    /**
     * @param value Subdirectory to perform actions as source or destination.
     */
    @JvmName("mhoupcogjpnavwqq")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pabmstfyxiqxjxdn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user who has the permissions to access files and folders in the FSx for Windows file system.
     */
    @JvmName("ibyuaocpfcglcral")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The name of the Windows domain that the FSx for Windows server belongs to.
     */
    @JvmName("wicqqdyximomkcip")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the FSx for Windows file system.
     */
    @JvmName("urldqogxxnscqevl")
    public suspend fun fsxFilesystemArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsxFilesystemArn = mapped
    }

    /**
     * @param value The password of the user who has the permissions to access files and folders in the FSx for Windows file system.
     */
    @JvmName("dbumbrvgnaeftjoy")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Windows file system.
     */
    @JvmName("pswancogvqyqwjeo")
    public suspend fun securityGroupArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param values The Amazon Resource Names (ARNs) of the security groups that are to use to configure the FSx for Windows file system.
     */
    @JvmName("bxkojeivwldjycin")
    public suspend fun securityGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param value Subdirectory to perform actions as source or destination.
     */
    @JvmName("bpnvncfgrcmpnlpf")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cfpxbyccgqqmkbwx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ibcfqtfiqpedskmi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user who has the permissions to access files and folders in the FSx for Windows file system.
     */
    @JvmName("vpedtuapgfirisav")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): LocationFsxWindowsArgs = LocationFsxWindowsArgs(
        domain = domain,
        fsxFilesystemArn = fsxFilesystemArn,
        password = password,
        securityGroupArns = securityGroupArns,
        subdirectory = subdirectory,
        tags = tags,
        user = user,
    )
}
