@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsNameNode
import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsQopConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsNameNode.Companion.toKotlin as locationHdfsNameNodeToKotlin
import com.pulumi.aws.datasync.kotlin.outputs.LocationHdfsQopConfiguration.Companion.toKotlin as locationHdfsQopConfigurationToKotlin

/**
 * Builder for [LocationHdfs].
 */
@PulumiTagMarker
public class LocationHdfsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationHdfsArgs = LocationHdfsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationHdfsArgsBuilder.() -> Unit) {
        val builder = LocationHdfsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocationHdfs {
        val builtJavaResource = com.pulumi.aws.datasync.LocationHdfs(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocationHdfs(builtJavaResource)
    }
}

/**
 * Manages an HDFS Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationHdfs("example", {
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     authenticationType: "SIMPLE",
 *     simpleUser: "example",
 *     nameNodes: [{
 *         hostname: exampleAwsInstance.privateDns,
 *         port: 80,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationHdfs("example",
 *     agent_arns=[example_aws_datasync_agent["arn"]],
 *     authentication_type="SIMPLE",
 *     simple_user="example",
 *     name_nodes=[{
 *         "hostname": example_aws_instance["privateDns"],
 *         "port": 80,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationHdfs("example", new()
 *     {
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *         AuthenticationType = "SIMPLE",
 *         SimpleUser = "example",
 *         NameNodes = new[]
 *         {
 *             new Aws.DataSync.Inputs.LocationHdfsNameNodeArgs
 *             {
 *                 Hostname = exampleAwsInstance.PrivateDns,
 *                 Port = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationHdfs(ctx, "example", &datasync.LocationHdfsArgs{
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 			AuthenticationType: pulumi.String("SIMPLE"),
 * 			SimpleUser:         pulumi.String("example"),
 * 			NameNodes: datasync.LocationHdfsNameNodeArray{
 * 				&datasync.LocationHdfsNameNodeArgs{
 * 					Hostname: pulumi.Any(exampleAwsInstance.PrivateDns),
 * 					Port:     pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationHdfs;
 * import com.pulumi.aws.datasync.LocationHdfsArgs;
 * import com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationHdfs("example", LocationHdfsArgs.builder()
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .authenticationType("SIMPLE")
 *             .simpleUser("example")
 *             .nameNodes(LocationHdfsNameNodeArgs.builder()
 *                 .hostname(exampleAwsInstance.privateDns())
 *                 .port(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationHdfs
 *     properties:
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 *       authenticationType: SIMPLE
 *       simpleUser: example
 *       nameNodes:
 *         - hostname: ${exampleAwsInstance.privateDns}
 *           port: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Kerberos Authentication
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.datasync.LocationHdfs("example", {
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     authenticationType: "KERBEROS",
 *     nameNodes: [{
 *         hostname: exampleAwsInstance.privateDns,
 *         port: 80,
 *     }],
 *     kerberosPrincipal: "user@example.com",
 *     kerberosKeytabBase64: std.filebase64({
 *         input: "user.keytab",
 *     }).then(invoke => invoke.result),
 *     kerberosKrb5Conf: std.file({
 *         input: "krb5.conf",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.datasync.LocationHdfs("example",
 *     agent_arns=[example_aws_datasync_agent["arn"]],
 *     authentication_type="KERBEROS",
 *     name_nodes=[{
 *         "hostname": example_aws_instance["privateDns"],
 *         "port": 80,
 *     }],
 *     kerberos_principal="user@example.com",
 *     kerberos_keytab_base64=std.filebase64(input="user.keytab").result,
 *     kerberos_krb5_conf=std.file(input="krb5.conf").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationHdfs("example", new()
 *     {
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *         AuthenticationType = "KERBEROS",
 *         NameNodes = new[]
 *         {
 *             new Aws.DataSync.Inputs.LocationHdfsNameNodeArgs
 *             {
 *                 Hostname = exampleAwsInstance.PrivateDns,
 *                 Port = 80,
 *             },
 *         },
 *         KerberosPrincipal = "user@example.com",
 *         KerberosKeytabBase64 = Std.Filebase64.Invoke(new()
 *         {
 *             Input = "user.keytab",
 *         }).Apply(invoke => invoke.Result),
 *         KerberosKrb5Conf = Std.File.Invoke(new()
 *         {
 *             Input = "krb5.conf",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFilebase64, err := std.Filebase64(ctx, &std.Filebase64Args{
 * 			Input: "user.keytab",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile1, err := std.File(ctx, &std.FileArgs{
 * 			Input: "krb5.conf",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = datasync.NewLocationHdfs(ctx, "example", &datasync.LocationHdfsArgs{
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 			AuthenticationType: pulumi.String("KERBEROS"),
 * 			NameNodes: datasync.LocationHdfsNameNodeArray{
 * 				&datasync.LocationHdfsNameNodeArgs{
 * 					Hostname: pulumi.Any(exampleAwsInstance.PrivateDns),
 * 					Port:     pulumi.Int(80),
 * 				},
 * 			},
 * 			KerberosPrincipal:    pulumi.String("user@example.com"),
 * 			KerberosKeytabBase64: pulumi.String(invokeFilebase64.Result),
 * 			KerberosKrb5Conf:     pulumi.String(invokeFile1.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationHdfs;
 * import com.pulumi.aws.datasync.LocationHdfsArgs;
 * import com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationHdfs("example", LocationHdfsArgs.builder()
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .authenticationType("KERBEROS")
 *             .nameNodes(LocationHdfsNameNodeArgs.builder()
 *                 .hostname(exampleAwsInstance.privateDns())
 *                 .port(80)
 *                 .build())
 *             .kerberosPrincipal("user@example.com")
 *             .kerberosKeytabBase64(StdFunctions.filebase64(Filebase64Args.builder()
 *                 .input("user.keytab")
 *                 .build()).result())
 *             .kerberosKrb5Conf(StdFunctions.file(FileArgs.builder()
 *                 .input("krb5.conf")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationHdfs
 *     properties:
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 *       authenticationType: KERBEROS
 *       nameNodes:
 *         - hostname: ${exampleAwsInstance.privateDns}
 *           port: 80
 *       kerberosPrincipal: user@example.com
 *       kerberosKeytabBase64:
 *         fn::invoke:
 *           Function: std:filebase64
 *           Arguments:
 *             input: user.keytab
 *           Return: result
 *       kerberosKrb5Conf:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: krb5.conf
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_hdfs` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/locationHdfs:LocationHdfs example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 */
public class LocationHdfs internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationHdfs,
) : KotlinCustomResource(javaResource, LocationHdfsMapper) {
    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     */
    public val agentArns: Output<List<String>>
        get() = javaResource.agentArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The type of authentication used to determine the identity of the user. Valid values are `SIMPLE` and `KERBEROS`.
     */
    public val authenticationType: Output<String>?
        get() = javaResource.authenticationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of data blocks to write into the HDFS cluster. The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     */
    public val blockSize: Output<Int>?
        get() = javaResource.blockSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys. Use `kerberos_keytab_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab_base64`) is required.
     */
    public val kerberosKeytab: Output<String>?
        get() = javaResource.kerberosKeytab().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Use instead of `kerberos_keytab` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_keytab`) is required.
     */
    public val kerberosKeytabBase64: Output<String>?
        get() = javaResource.kerberosKeytabBase64().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The krb5.conf file that contains the Kerberos configuration information. Use `kerberos_krb5_conf_base64` instead whenever the value is not a valid UTF-8 string. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf_base64`) is required.
     */
    public val kerberosKrb5Conf: Output<String>?
        get() = javaResource.kerberosKrb5Conf().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Use instead of `kerberos_krb5_conf` to pass base64-encoded binary data directly. If `KERBEROS` is specified for `authentication_type`, this parameter (or `kerberos_krb5_conf`) is required.
     */
    public val kerberosKrb5ConfBase64: Output<String>?
        get() = javaResource.kerberosKrb5ConfBase64().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Kerberos principal with access to the files and folders on the HDFS cluster. If `KERBEROS` is specified for `authentication_type`, this parameter is required.
     */
    public val kerberosPrincipal: Output<String>?
        get() = javaResource.kerberosPrincipal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URI of the HDFS cluster's Key Management Server (KMS).
     */
    public val kmsKeyProviderUri: Output<String>?
        get() = javaResource.kmsKeyProviderUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The NameNode that manages the HDFS namespace. The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode. See configuration below.
     */
    public val nameNodes: Output<List<LocationHdfsNameNode>>
        get() = javaResource.nameNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    locationHdfsNameNodeToKotlin(args0)
                })
            })
        })

    /**
     * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `qop_configuration` isn't specified, `rpc_protection` and `data_transfer_protection` default to `PRIVACY`. If you set RpcProtection or DataTransferProtection, the other parameter assumes the same value.  See configuration below.
     */
    public val qopConfiguration: Output<LocationHdfsQopConfiguration>
        get() = javaResource.qopConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                locationHdfsQopConfigurationToKotlin(args0)
            })
        })

    /**
     * The number of DataNodes to replicate the data to when writing to the HDFS cluster. By default, data is replicated to three DataNodes.
     */
    public val replicationFactor: Output<Int>?
        get() = javaResource.replicationFactor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The user name used to identify the client on the host operating system. If `SIMPLE` is specified for `authentication_type`, this parameter is required.
     */
    public val simpleUser: Output<String>?
        get() = javaResource.simpleUser().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
     */
    public val subdirectory: Output<String>?
        get() = javaResource.subdirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object LocationHdfsMapper : ResourceMapper<LocationHdfs> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationHdfs::class == javaResource::class

    override fun map(javaResource: Resource): LocationHdfs = LocationHdfs(
        javaResource as
            com.pulumi.aws.datasync.LocationHdfs,
    )
}

/**
 * @see [LocationHdfs].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationHdfs].
 */
public suspend fun locationHdfs(
    name: String,
    block: suspend LocationHdfsResourceBuilder.() -> Unit,
): LocationHdfs {
    val builder = LocationHdfsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationHdfs].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationHdfs(name: String): LocationHdfs {
    val builder = LocationHdfsResourceBuilder()
    builder.name(name)
    return builder.build()
}
