@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LocationObjectStorage].
 */
@PulumiTagMarker
public class LocationObjectStorageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationObjectStorageArgs = LocationObjectStorageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationObjectStorageArgsBuilder.() -> Unit) {
        val builder = LocationObjectStorageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocationObjectStorage {
        val builtJavaResource = com.pulumi.aws.datasync.LocationObjectStorage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocationObjectStorage(builtJavaResource)
    }
}

/**
 * Manages a Object Storage Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationObjectStorage("example", {
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     serverHostname: "example",
 *     bucketName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationObjectStorage("example",
 *     agent_arns=[example_aws_datasync_agent["arn"]],
 *     server_hostname="example",
 *     bucket_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationObjectStorage("example", new()
 *     {
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *         ServerHostname = "example",
 *         BucketName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationObjectStorage(ctx, "example", &datasync.LocationObjectStorageArgs{
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 			ServerHostname: pulumi.String("example"),
 * 			BucketName:     pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationObjectStorage;
 * import com.pulumi.aws.datasync.LocationObjectStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationObjectStorage("example", LocationObjectStorageArgs.builder()
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .serverHostname("example")
 *             .bucketName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationObjectStorage
 *     properties:
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 *       serverHostname: example
 *       bucketName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_object_storage` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/locationObjectStorage:LocationObjectStorage example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 */
public class LocationObjectStorage internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationObjectStorage,
) : KotlinCustomResource(javaResource, LocationObjectStorageMapper) {
    /**
     * The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     */
    public val accessKey: Output<String>?
        get() = javaResource.accessKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     */
    public val agentArns: Output<List<String>>
        get() = javaResource.agentArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The bucket on the self-managed object storage server that is used to read data from.
     */
    public val bucketName: Output<String>
        get() = javaResource.bucketName().applyValue({ args0 -> args0 })

    /**
     * The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     */
    public val secretKey: Output<String>?
        get() = javaResource.secretKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
     */
    public val serverCertificate: Output<String>?
        get() = javaResource.serverCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
     */
    public val serverHostname: Output<String>
        get() = javaResource.serverHostname().applyValue({ args0 -> args0 })

    /**
     * The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
     */
    public val serverPort: Output<Int>?
        get() = javaResource.serverPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
     */
    public val serverProtocol: Output<String>?
        get() = javaResource.serverProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The URL of the Object Storage location that was described.
     */
    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object LocationObjectStorageMapper : ResourceMapper<LocationObjectStorage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationObjectStorage::class == javaResource::class

    override fun map(javaResource: Resource): LocationObjectStorage =
        LocationObjectStorage(javaResource as com.pulumi.aws.datasync.LocationObjectStorage)
}

/**
 * @see [LocationObjectStorage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationObjectStorage].
 */
public suspend fun locationObjectStorage(
    name: String,
    block: suspend LocationObjectStorageResourceBuilder.() -> Unit,
): LocationObjectStorage {
    val builder = LocationObjectStorageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationObjectStorage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationObjectStorage(name: String): LocationObjectStorage {
    val builder = LocationObjectStorageResourceBuilder()
    builder.name(name)
    return builder.build()
}
