@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationObjectStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Object Storage Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationObjectStorage("example", {
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     serverHostname: "example",
 *     bucketName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationObjectStorage("example",
 *     agent_arns=[example_aws_datasync_agent["arn"]],
 *     server_hostname="example",
 *     bucket_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationObjectStorage("example", new()
 *     {
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *         ServerHostname = "example",
 *         BucketName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationObjectStorage(ctx, "example", &datasync.LocationObjectStorageArgs{
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 			ServerHostname: pulumi.String("example"),
 * 			BucketName:     pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationObjectStorage;
 * import com.pulumi.aws.datasync.LocationObjectStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationObjectStorage("example", LocationObjectStorageArgs.builder()
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .serverHostname("example")
 *             .bucketName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationObjectStorage
 *     properties:
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 *       serverHostname: example
 *       bucketName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_object_storage` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/locationObjectStorage:LocationObjectStorage example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property accessKey The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property bucketName The bucket on the self-managed object storage server that is used to read data from.
 * @property secretKey The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
 * @property serverCertificate Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
 * @property serverHostname The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
 * @property serverPort The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
 * @property serverProtocol The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
 * @property subdirectory A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LocationObjectStorageArgs(
    public val accessKey: Output<String>? = null,
    public val agentArns: Output<List<String>>? = null,
    public val bucketName: Output<String>? = null,
    public val secretKey: Output<String>? = null,
    public val serverCertificate: Output<String>? = null,
    public val serverHostname: Output<String>? = null,
    public val serverPort: Output<Int>? = null,
    public val serverProtocol: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationObjectStorageArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationObjectStorageArgs =
        com.pulumi.aws.datasync.LocationObjectStorageArgs.builder()
            .accessKey(accessKey?.applyValue({ args0 -> args0 }))
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .secretKey(secretKey?.applyValue({ args0 -> args0 }))
            .serverCertificate(serverCertificate?.applyValue({ args0 -> args0 }))
            .serverHostname(serverHostname?.applyValue({ args0 -> args0 }))
            .serverPort(serverPort?.applyValue({ args0 -> args0 }))
            .serverProtocol(serverProtocol?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocationObjectStorageArgs].
 */
@PulumiTagMarker
public class LocationObjectStorageArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var agentArns: Output<List<String>>? = null

    private var bucketName: Output<String>? = null

    private var secretKey: Output<String>? = null

    private var serverCertificate: Output<String>? = null

    private var serverHostname: Output<String>? = null

    private var serverPort: Output<Int>? = null

    private var serverProtocol: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     */
    @JvmName("grrhstkfedjndmpu")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("qdcjsqqnpmniqpkd")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("rlpqtoolbokvhowi")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("misdykcautcvnmur")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value The bucket on the self-managed object storage server that is used to read data from.
     */
    @JvmName("ppmrsnbstcrfxdwd")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     */
    @JvmName("xtkfyvqfqalwuwiq")
    public suspend fun secretKey(`value`: Output<String>) {
        this.secretKey = value
    }

    /**
     * @param value Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
     */
    @JvmName("qxfmktsmfocrrgac")
    public suspend fun serverCertificate(`value`: Output<String>) {
        this.serverCertificate = value
    }

    /**
     * @param value The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
     */
    @JvmName("iimwygmcdsdejvhn")
    public suspend fun serverHostname(`value`: Output<String>) {
        this.serverHostname = value
    }

    /**
     * @param value The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
     */
    @JvmName("rjybwehyepknbxke")
    public suspend fun serverPort(`value`: Output<Int>) {
        this.serverPort = value
    }

    /**
     * @param value The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
     */
    @JvmName("uegoqhrrnquohwqg")
    public suspend fun serverProtocol(`value`: Output<String>) {
        this.serverProtocol = value
    }

    /**
     * @param value A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
     */
    @JvmName("yarcuiairtygeibx")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vletsliumignibic")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The access key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     */
    @JvmName("odspuutfswdeanqr")
    public suspend fun accessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("mmkybsvwkvufiodj")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("nabkxxmqljsjmhkp")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value The bucket on the self-managed object storage server that is used to read data from.
     */
    @JvmName("ekohviglvijyjqko")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The secret key is used if credentials are required to access the self-managed object storage server. If your object storage requires a user name and password to authenticate, use `access_key` and `secret_key` to provide the user name and password, respectively.
     */
    @JvmName("jqasnsekgpcyfuqo")
    public suspend fun secretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretKey = mapped
    }

    /**
     * @param value Specifies a certificate to authenticate with an object storage system that uses a private or self-signed certificate authority (CA). You must specify a Base64-encoded .pem string. The certificate can be up to 32768 bytes (before Base64 encoding).
     */
    @JvmName("salnaipduwugtevw")
    public suspend fun serverCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificate = mapped
    }

    /**
     * @param value The name of the self-managed object storage server. This value is the IP address or Domain Name Service (DNS) name of the object storage server. An agent uses this host name to mount the object storage server in a network.
     */
    @JvmName("vmeqwgevghuqqnty")
    public suspend fun serverHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverHostname = mapped
    }

    /**
     * @param value The port that your self-managed object storage server accepts inbound network traffic on. The server port is set by default to TCP 80 (`HTTP`) or TCP 443 (`HTTPS`). You can specify a custom port if your self-managed object storage server requires one.
     */
    @JvmName("oabydalpgrftskqy")
    public suspend fun serverPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverPort = mapped
    }

    /**
     * @param value The protocol that the object storage server uses to communicate. Valid values are `HTTP` or `HTTPS`.
     */
    @JvmName("usbrtscwmssekloc")
    public suspend fun serverProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverProtocol = mapped
    }

    /**
     * @param value A subdirectory in the HDFS cluster. This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to /.
     */
    @JvmName("idmairiensjdmvcn")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fydwxcwhhsdfkacv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mlhtilsrgurcfjok")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocationObjectStorageArgs = LocationObjectStorageArgs(
        accessKey = accessKey,
        agentArns = agentArns,
        bucketName = bucketName,
        secretKey = secretKey,
        serverCertificate = serverCertificate,
        serverHostname = serverHostname,
        serverPort = serverPort,
        serverProtocol = serverProtocol,
        subdirectory = subdirectory,
        tags = tags,
    )
}
