@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.LocationSmbMountOptions
import com.pulumi.aws.datasync.kotlin.outputs.LocationSmbMountOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LocationSmb].
 */
@PulumiTagMarker
public class LocationSmbResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocationSmbArgs = LocationSmbArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocationSmbArgsBuilder.() -> Unit) {
        val builder = LocationSmbArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocationSmb {
        val builtJavaResource = com.pulumi.aws.datasync.LocationSmb(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocationSmb(builtJavaResource)
    }
}

/**
 * Manages a SMB Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationSmb("example", {
 *     serverHostname: "smb.example.com",
 *     subdirectory: "/exported/path",
 *     user: "Guest",
 *     password: "ANotGreatPassword",
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationSmb("example",
 *     server_hostname="smb.example.com",
 *     subdirectory="/exported/path",
 *     user="Guest",
 *     password="ANotGreatPassword",
 *     agent_arns=[example_aws_datasync_agent["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationSmb("example", new()
 *     {
 *         ServerHostname = "smb.example.com",
 *         Subdirectory = "/exported/path",
 *         User = "Guest",
 *         Password = "ANotGreatPassword",
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationSmb(ctx, "example", &datasync.LocationSmbArgs{
 * 			ServerHostname: pulumi.String("smb.example.com"),
 * 			Subdirectory:   pulumi.String("/exported/path"),
 * 			User:           pulumi.String("Guest"),
 * 			Password:       pulumi.String("ANotGreatPassword"),
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationSmb;
 * import com.pulumi.aws.datasync.LocationSmbArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationSmb("example", LocationSmbArgs.builder()
 *             .serverHostname("smb.example.com")
 *             .subdirectory("/exported/path")
 *             .user("Guest")
 *             .password("ANotGreatPassword")
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationSmb
 *     properties:
 *       serverHostname: smb.example.com
 *       subdirectory: /exported/path
 *       user: Guest
 *       password: ANotGreatPassword
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_smb` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/locationSmb:LocationSmb example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 */
public class LocationSmb internal constructor(
    override val javaResource: com.pulumi.aws.datasync.LocationSmb,
) : KotlinCustomResource(javaResource, LocationSmbMapper) {
    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     */
    public val agentArns: Output<List<String>>
        get() = javaResource.agentArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the Windows domain the SMB server belongs to.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     */
    public val mountOptions: Output<LocationSmbMountOptions>?
        get() = javaResource.mountOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The password of the user who can mount the share and has file permissions in the SMB.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
     */
    public val serverHostname: Output<String>
        get() = javaResource.serverHostname().applyValue({ args0 -> args0 })

    /**
     * Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })

    /**
     * The user who can mount the share and has file and folder permissions in the SMB share.
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object LocationSmbMapper : ResourceMapper<LocationSmb> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.LocationSmb::class == javaResource::class

    override fun map(javaResource: Resource): LocationSmb = LocationSmb(
        javaResource as
            com.pulumi.aws.datasync.LocationSmb,
    )
}

/**
 * @see [LocationSmb].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocationSmb].
 */
public suspend fun locationSmb(name: String, block: suspend LocationSmbResourceBuilder.() -> Unit): LocationSmb {
    val builder = LocationSmbResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocationSmb].
 * @param name The _unique_ name of the resulting resource.
 */
public fun locationSmb(name: String): LocationSmb {
    val builder = LocationSmbResourceBuilder()
    builder.name(name)
    return builder.build()
}
