@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.LocationSmbArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.LocationSmbMountOptionsArgs
import com.pulumi.aws.datasync.kotlin.inputs.LocationSmbMountOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a SMB Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.LocationSmb("example", {
 *     serverHostname: "smb.example.com",
 *     subdirectory: "/exported/path",
 *     user: "Guest",
 *     password: "ANotGreatPassword",
 *     agentArns: [exampleAwsDatasyncAgent&#46;arn],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.LocationSmb("example",
 *     server_hostname="smb.example.com",
 *     subdirectory="/exported/path",
 *     user="Guest",
 *     password="ANotGreatPassword",
 *     agent_arns=[example_aws_datasync_agent["arn"]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.LocationSmb("example", new()
 *     {
 *         ServerHostname = "smb.example.com",
 *         Subdirectory = "/exported/path",
 *         User = "Guest",
 *         Password = "ANotGreatPassword",
 *         AgentArns = new[]
 *         {
 *             exampleAwsDatasyncAgent.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewLocationSmb(ctx, "example", &datasync.LocationSmbArgs{
 * 			ServerHostname: pulumi.String("smb.example.com"),
 * 			Subdirectory:   pulumi.String("/exported/path"),
 * 			User:           pulumi.String("Guest"),
 * 			Password:       pulumi.String("ANotGreatPassword"),
 * 			AgentArns: pulumi.StringArray{
 * 				exampleAwsDatasyncAgent.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.LocationSmb;
 * import com.pulumi.aws.datasync.LocationSmbArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocationSmb("example", LocationSmbArgs.builder()
 *             .serverHostname("smb.example.com")
 *             .subdirectory("/exported/path")
 *             .user("Guest")
 *             .password("ANotGreatPassword")
 *             .agentArns(exampleAwsDatasyncAgent.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:LocationSmb
 *     properties:
 *       serverHostname: smb.example.com
 *       subdirectory: /exported/path
 *       user: Guest
 *       password: ANotGreatPassword
 *       agentArns:
 *         - ${exampleAwsDatasyncAgent.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_smb` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/locationSmb:LocationSmb example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property domain The name of the Windows domain the SMB server belongs to.
 * @property mountOptions Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
 * @property password The password of the user who can mount the share and has file permissions in the SMB.
 * @property serverHostname Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
 * @property subdirectory Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property user The user who can mount the share and has file and folder permissions in the SMB share.
 */
public data class LocationSmbArgs(
    public val agentArns: Output<List<String>>? = null,
    public val domain: Output<String>? = null,
    public val mountOptions: Output<LocationSmbMountOptionsArgs>? = null,
    public val password: Output<String>? = null,
    public val serverHostname: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.LocationSmbArgs> {
    override fun toJava(): com.pulumi.aws.datasync.LocationSmbArgs =
        com.pulumi.aws.datasync.LocationSmbArgs.builder()
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .mountOptions(mountOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .password(password?.applyValue({ args0 -> args0 }))
            .serverHostname(serverHostname?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationSmbArgs].
 */
@PulumiTagMarker
public class LocationSmbArgsBuilder internal constructor() {
    private var agentArns: Output<List<String>>? = null

    private var domain: Output<String>? = null

    private var mountOptions: Output<LocationSmbMountOptionsArgs>? = null

    private var password: Output<String>? = null

    private var serverHostname: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var user: Output<String>? = null

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("xexotiwhmjxmijcq")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("nkvblvsocxlwdajy")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("gogsdbstdcptwgjw")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value The name of the Windows domain the SMB server belongs to.
     */
    @JvmName("oejjkuwqqmbegcvd")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     */
    @JvmName("npfnkrprbidyvexh")
    public suspend fun mountOptions(`value`: Output<LocationSmbMountOptionsArgs>) {
        this.mountOptions = value
    }

    /**
     * @param value The password of the user who can mount the share and has file permissions in the SMB.
     */
    @JvmName("rwvbcfjkiuiogicj")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
     */
    @JvmName("kewvnywlvbpltqmi")
    public suspend fun serverHostname(`value`: Output<String>) {
        this.serverHostname = value
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    @JvmName("jyjgaktggimeoyyo")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nhdfrnnhfcofrwvj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user who can mount the share and has file and folder permissions in the SMB share.
     */
    @JvmName("lsknyrpodlsqpxmo")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("rgnlmpojxuashbix")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("bnkubyhpacjhpmrh")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value The name of the Windows domain the SMB server belongs to.
     */
    @JvmName("tcqdwpcjgwfufusx")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     */
    @JvmName("kwfuunojydguesur")
    public suspend fun mountOptions(`value`: LocationSmbMountOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param argument Configuration block containing mount options used by DataSync to access the SMB Server. Can be `AUTOMATIC`, `SMB2`, or `SMB3`.
     */
    @JvmName("ogwmrgrvivkxkwsb")
    public suspend fun mountOptions(argument: suspend LocationSmbMountOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LocationSmbMountOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mountOptions = mapped
    }

    /**
     * @param value The password of the user who can mount the share and has file permissions in the SMB.
     */
    @JvmName("rcvmqmvupliriqps")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Specifies the IP address or DNS name of the SMB server. The DataSync Agent(s) use this to mount the SMB share.
     */
    @JvmName("vifqshqmevweqoxj")
    public suspend fun serverHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverHostname = mapped
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    @JvmName("ljjisoyfwggjmtsp")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ajfifydulbblfaql")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gjxmjpmeyilfjpyp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user who can mount the share and has file and folder permissions in the SMB share.
     */
    @JvmName("oxwfgdjabcrhdapu")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): LocationSmbArgs = LocationSmbArgs(
        agentArns = agentArns,
        domain = domain,
        mountOptions = mountOptions,
        password = password,
        serverHostname = serverHostname,
        subdirectory = subdirectory,
        tags = tags,
        user = user,
    )
}
