@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.NfsLocationMountOptions
import com.pulumi.aws.datasync.kotlin.outputs.NfsLocationOnPremConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.datasync.kotlin.outputs.NfsLocationMountOptions.Companion.toKotlin as nfsLocationMountOptionsToKotlin
import com.pulumi.aws.datasync.kotlin.outputs.NfsLocationOnPremConfig.Companion.toKotlin as nfsLocationOnPremConfigToKotlin

/**
 * Builder for [NfsLocation].
 */
@PulumiTagMarker
public class NfsLocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NfsLocationArgs = NfsLocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NfsLocationArgsBuilder.() -> Unit) {
        val builder = NfsLocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NfsLocation {
        val builtJavaResource = com.pulumi.aws.datasync.NfsLocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NfsLocation(builtJavaResource)
    }
}

/**
 * Manages an NFS Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.NfsLocation("example", {
 *     serverHostname: "nfs.example.com",
 *     subdirectory: "/exported/path",
 *     onPremConfig: {
 *         agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.NfsLocation("example",
 *     server_hostname="nfs.example.com",
 *     subdirectory="/exported/path",
 *     on_prem_config={
 *         "agent_arns": [example_aws_datasync_agent["arn"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.NfsLocation("example", new()
 *     {
 *         ServerHostname = "nfs.example.com",
 *         Subdirectory = "/exported/path",
 *         OnPremConfig = new Aws.DataSync.Inputs.NfsLocationOnPremConfigArgs
 *         {
 *             AgentArns = new[]
 *             {
 *                 exampleAwsDatasyncAgent.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewNfsLocation(ctx, "example", &datasync.NfsLocationArgs{
 * 			ServerHostname: pulumi.String("nfs.example.com"),
 * 			Subdirectory:   pulumi.String("/exported/path"),
 * 			OnPremConfig: &datasync.NfsLocationOnPremConfigArgs{
 * 				AgentArns: pulumi.StringArray{
 * 					exampleAwsDatasyncAgent.Arn,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.NfsLocation;
 * import com.pulumi.aws.datasync.NfsLocationArgs;
 * import com.pulumi.aws.datasync.inputs.NfsLocationOnPremConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NfsLocation("example", NfsLocationArgs.builder()
 *             .serverHostname("nfs.example.com")
 *             .subdirectory("/exported/path")
 *             .onPremConfig(NfsLocationOnPremConfigArgs.builder()
 *                 .agentArns(exampleAwsDatasyncAgent.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:NfsLocation
 *     properties:
 *       serverHostname: nfs.example.com
 *       subdirectory: /exported/path
 *       onPremConfig:
 *         agentArns:
 *           - ${exampleAwsDatasyncAgent.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_nfs` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/nfsLocation:NfsLocation example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 */
public class NfsLocation internal constructor(
    override val javaResource: com.pulumi.aws.datasync.NfsLocation,
) : KotlinCustomResource(javaResource, NfsLocationMapper) {
    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing mount options used by DataSync to access the NFS Server.
     */
    public val mountOptions: Output<NfsLocationMountOptions>?
        get() = javaResource.mountOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    nfsLocationMountOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration block containing information for connecting to the NFS File System.
     */
    public val onPremConfig: Output<NfsLocationOnPremConfig>
        get() = javaResource.onPremConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                nfsLocationOnPremConfigToKotlin(args0)
            })
        })

    /**
     * Specifies the IP address or DNS name of the NFS server. The DataSync Agent(s) use this to mount the NFS server.
     */
    public val serverHostname: Output<String>
        get() = javaResource.serverHostname().applyValue({ args0 -> args0 })

    /**
     * Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object NfsLocationMapper : ResourceMapper<NfsLocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.NfsLocation::class == javaResource::class

    override fun map(javaResource: Resource): NfsLocation = NfsLocation(
        javaResource as
            com.pulumi.aws.datasync.NfsLocation,
    )
}

/**
 * @see [NfsLocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NfsLocation].
 */
public suspend fun nfsLocation(name: String, block: suspend NfsLocationResourceBuilder.() -> Unit): NfsLocation {
    val builder = NfsLocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NfsLocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nfsLocation(name: String): NfsLocation {
    val builder = NfsLocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
