@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.NfsLocationArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.NfsLocationMountOptionsArgs
import com.pulumi.aws.datasync.kotlin.inputs.NfsLocationMountOptionsArgsBuilder
import com.pulumi.aws.datasync.kotlin.inputs.NfsLocationOnPremConfigArgs
import com.pulumi.aws.datasync.kotlin.inputs.NfsLocationOnPremConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an NFS Location within AWS DataSync.
 * > **NOTE:** The DataSync Agents must be available before creating this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.NfsLocation("example", {
 *     serverHostname: "nfs.example.com",
 *     subdirectory: "/exported/path",
 *     onPremConfig: {
 *         agentArns: [exampleAwsDatasyncAgent&#46;arn],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.NfsLocation("example",
 *     server_hostname="nfs.example.com",
 *     subdirectory="/exported/path",
 *     on_prem_config={
 *         "agent_arns": [example_aws_datasync_agent["arn"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.NfsLocation("example", new()
 *     {
 *         ServerHostname = "nfs.example.com",
 *         Subdirectory = "/exported/path",
 *         OnPremConfig = new Aws.DataSync.Inputs.NfsLocationOnPremConfigArgs
 *         {
 *             AgentArns = new[]
 *             {
 *                 exampleAwsDatasyncAgent.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewNfsLocation(ctx, "example", &datasync.NfsLocationArgs{
 * 			ServerHostname: pulumi.String("nfs.example.com"),
 * 			Subdirectory:   pulumi.String("/exported/path"),
 * 			OnPremConfig: &datasync.NfsLocationOnPremConfigArgs{
 * 				AgentArns: pulumi.StringArray{
 * 					exampleAwsDatasyncAgent.Arn,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.NfsLocation;
 * import com.pulumi.aws.datasync.NfsLocationArgs;
 * import com.pulumi.aws.datasync.inputs.NfsLocationOnPremConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NfsLocation("example", NfsLocationArgs.builder()
 *             .serverHostname("nfs.example.com")
 *             .subdirectory("/exported/path")
 *             .onPremConfig(NfsLocationOnPremConfigArgs.builder()
 *                 .agentArns(exampleAwsDatasyncAgent.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:NfsLocation
 *     properties:
 *       serverHostname: nfs.example.com
 *       subdirectory: /exported/path
 *       onPremConfig:
 *         agentArns:
 *           - ${exampleAwsDatasyncAgent.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_nfs` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/nfsLocation:NfsLocation example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property mountOptions Configuration block containing mount options used by DataSync to access the NFS Server.
 * @property onPremConfig Configuration block containing information for connecting to the NFS File System.
 * @property serverHostname Specifies the IP address or DNS name of the NFS server. The DataSync Agent(s) use this to mount the NFS server.
 * @property subdirectory Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class NfsLocationArgs(
    public val mountOptions: Output<NfsLocationMountOptionsArgs>? = null,
    public val onPremConfig: Output<NfsLocationOnPremConfigArgs>? = null,
    public val serverHostname: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.NfsLocationArgs> {
    override fun toJava(): com.pulumi.aws.datasync.NfsLocationArgs =
        com.pulumi.aws.datasync.NfsLocationArgs.builder()
            .mountOptions(mountOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onPremConfig(onPremConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serverHostname(serverHostname?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NfsLocationArgs].
 */
@PulumiTagMarker
public class NfsLocationArgsBuilder internal constructor() {
    private var mountOptions: Output<NfsLocationMountOptionsArgs>? = null

    private var onPremConfig: Output<NfsLocationOnPremConfigArgs>? = null

    private var serverHostname: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block containing mount options used by DataSync to access the NFS Server.
     */
    @JvmName("tubewdflbamfnxak")
    public suspend fun mountOptions(`value`: Output<NfsLocationMountOptionsArgs>) {
        this.mountOptions = value
    }

    /**
     * @param value Configuration block containing information for connecting to the NFS File System.
     */
    @JvmName("dpvxaiywylncdivs")
    public suspend fun onPremConfig(`value`: Output<NfsLocationOnPremConfigArgs>) {
        this.onPremConfig = value
    }

    /**
     * @param value Specifies the IP address or DNS name of the NFS server. The DataSync Agent(s) use this to mount the NFS server.
     */
    @JvmName("dnfkbfnguyvgvphx")
    public suspend fun serverHostname(`value`: Output<String>) {
        this.serverHostname = value
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    @JvmName("jxoahfnawkqohqsf")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("feyvoqsusbbrxnra")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block containing mount options used by DataSync to access the NFS Server.
     */
    @JvmName("sjxsueorigntmsqc")
    public suspend fun mountOptions(`value`: NfsLocationMountOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param argument Configuration block containing mount options used by DataSync to access the NFS Server.
     */
    @JvmName("cpaskyeqqnbupxkk")
    public suspend fun mountOptions(argument: suspend NfsLocationMountOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = NfsLocationMountOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mountOptions = mapped
    }

    /**
     * @param value Configuration block containing information for connecting to the NFS File System.
     */
    @JvmName("wvkblkgpbroawsjd")
    public suspend fun onPremConfig(`value`: NfsLocationOnPremConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremConfig = mapped
    }

    /**
     * @param argument Configuration block containing information for connecting to the NFS File System.
     */
    @JvmName("qajsqguaklcvlqgm")
    public suspend fun onPremConfig(argument: suspend NfsLocationOnPremConfigArgsBuilder.() -> Unit) {
        val toBeMapped = NfsLocationOnPremConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onPremConfig = mapped
    }

    /**
     * @param value Specifies the IP address or DNS name of the NFS server. The DataSync Agent(s) use this to mount the NFS server.
     */
    @JvmName("immxhjheeumfvlqg")
    public suspend fun serverHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverHostname = mapped
    }

    /**
     * @param value Subdirectory to perform actions as source or destination. Should be exported by the NFS server.
     */
    @JvmName("xckyajnaieswfqst")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iouobhcralvwjbtd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eitnsossfofaaocb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NfsLocationArgs = NfsLocationArgs(
        mountOptions = mountOptions,
        onPremConfig = onPremConfig,
        serverHostname = serverHostname,
        subdirectory = subdirectory,
        tags = tags,
    )
}
