@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.S3LocationS3Config
import com.pulumi.aws.datasync.kotlin.outputs.S3LocationS3Config.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [S3Location].
 */
@PulumiTagMarker
public class S3LocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: S3LocationArgs = S3LocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend S3LocationArgsBuilder.() -> Unit) {
        val builder = S3LocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): S3Location {
        val builtJavaResource = com.pulumi.aws.datasync.S3Location(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return S3Location(builtJavaResource)
    }
}

/**
 * Manages an S3 Location within AWS DataSync.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.S3Location("example", {
 *     s3BucketArn: exampleAwsS3Bucket.arn,
 *     subdirectory: "/example/prefix",
 *     s3Config: {
 *         bucketAccessRoleArn: exampleAwsIamRole.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.S3Location("example",
 *     s3_bucket_arn=example_aws_s3_bucket["arn"],
 *     subdirectory="/example/prefix",
 *     s3_config={
 *         "bucket_access_role_arn": example_aws_iam_role["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.S3Location("example", new()
 *     {
 *         S3BucketArn = exampleAwsS3Bucket.Arn,
 *         Subdirectory = "/example/prefix",
 *         S3Config = new Aws.DataSync.Inputs.S3LocationS3ConfigArgs
 *         {
 *             BucketAccessRoleArn = exampleAwsIamRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewS3Location(ctx, "example", &datasync.S3LocationArgs{
 * 			S3BucketArn:  pulumi.Any(exampleAwsS3Bucket.Arn),
 * 			Subdirectory: pulumi.String("/example/prefix"),
 * 			S3Config: &datasync.S3LocationS3ConfigArgs{
 * 				BucketAccessRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.S3Location;
 * import com.pulumi.aws.datasync.S3LocationArgs;
 * import com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new S3Location("example", S3LocationArgs.builder()
 *             .s3BucketArn(exampleAwsS3Bucket.arn())
 *             .subdirectory("/example/prefix")
 *             .s3Config(S3LocationS3ConfigArgs.builder()
 *                 .bucketAccessRoleArn(exampleAwsIamRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:S3Location
 *     properties:
 *       s3BucketArn: ${exampleAwsS3Bucket.arn}
 *       subdirectory: /example/prefix
 *       s3Config:
 *         bucketAccessRoleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_s3` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/s3Location:S3Location example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 */
public class S3Location internal constructor(
    override val javaResource: com.pulumi.aws.datasync.S3Location,
) : KotlinCustomResource(javaResource, S3LocationMapper) {
    /**
     * A list of DataSync Agent ARNs with which this location will be associated.
     */
    public val agentArns: Output<List<String>>?
        get() = javaResource.agentArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the DataSync Location.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the S3 Bucket.
     */
    public val s3BucketArn: Output<String>
        get() = javaResource.s3BucketArn().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing information for connecting to S3.
     */
    public val s3Config: Output<S3LocationS3Config>
        get() = javaResource.s3Config().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     */
    public val s3StorageClass: Output<String>
        get() = javaResource.s3StorageClass().applyValue({ args0 -> args0 })

    /**
     * Prefix to perform actions as source or destination.
     */
    public val subdirectory: Output<String>
        get() = javaResource.subdirectory().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val uri: Output<String>
        get() = javaResource.uri().applyValue({ args0 -> args0 })
}

public object S3LocationMapper : ResourceMapper<S3Location> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.S3Location::class == javaResource::class

    override fun map(javaResource: Resource): S3Location = S3Location(
        javaResource as
            com.pulumi.aws.datasync.S3Location,
    )
}

/**
 * @see [S3Location].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [S3Location].
 */
public suspend fun s3Location(name: String, block: suspend S3LocationResourceBuilder.() -> Unit): S3Location {
    val builder = S3LocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [S3Location].
 * @param name The _unique_ name of the resulting resource.
 */
public fun s3Location(name: String): S3Location {
    val builder = S3LocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
