@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.S3LocationArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.S3LocationS3ConfigArgs
import com.pulumi.aws.datasync.kotlin.inputs.S3LocationS3ConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an S3 Location within AWS DataSync.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.S3Location("example", {
 *     s3BucketArn: exampleAwsS3Bucket.arn,
 *     subdirectory: "/example/prefix",
 *     s3Config: {
 *         bucketAccessRoleArn: exampleAwsIamRole.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.S3Location("example",
 *     s3_bucket_arn=example_aws_s3_bucket["arn"],
 *     subdirectory="/example/prefix",
 *     s3_config={
 *         "bucket_access_role_arn": example_aws_iam_role["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.S3Location("example", new()
 *     {
 *         S3BucketArn = exampleAwsS3Bucket.Arn,
 *         Subdirectory = "/example/prefix",
 *         S3Config = new Aws.DataSync.Inputs.S3LocationS3ConfigArgs
 *         {
 *             BucketAccessRoleArn = exampleAwsIamRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewS3Location(ctx, "example", &datasync.S3LocationArgs{
 * 			S3BucketArn:  pulumi.Any(exampleAwsS3Bucket.Arn),
 * 			Subdirectory: pulumi.String("/example/prefix"),
 * 			S3Config: &datasync.S3LocationS3ConfigArgs{
 * 				BucketAccessRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.S3Location;
 * import com.pulumi.aws.datasync.S3LocationArgs;
 * import com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new S3Location("example", S3LocationArgs.builder()
 *             .s3BucketArn(exampleAwsS3Bucket.arn())
 *             .subdirectory("/example/prefix")
 *             .s3Config(S3LocationS3ConfigArgs.builder()
 *                 .bucketAccessRoleArn(exampleAwsIamRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:S3Location
 *     properties:
 *       s3BucketArn: ${exampleAwsS3Bucket.arn}
 *       subdirectory: /example/prefix
 *       s3Config:
 *         bucketAccessRoleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_s3` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/s3Location:S3Location example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property s3BucketArn Amazon Resource Name (ARN) of the S3 Bucket.
 * @property s3Config Configuration block containing information for connecting to S3.
 * @property s3StorageClass The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
 * @property subdirectory Prefix to perform actions as source or destination.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class S3LocationArgs(
    public val agentArns: Output<List<String>>? = null,
    public val s3BucketArn: Output<String>? = null,
    public val s3Config: Output<S3LocationS3ConfigArgs>? = null,
    public val s3StorageClass: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.S3LocationArgs> {
    override fun toJava(): com.pulumi.aws.datasync.S3LocationArgs =
        com.pulumi.aws.datasync.S3LocationArgs.builder()
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .s3BucketArn(s3BucketArn?.applyValue({ args0 -> args0 }))
            .s3Config(s3Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3StorageClass(s3StorageClass?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [S3LocationArgs].
 */
@PulumiTagMarker
public class S3LocationArgsBuilder internal constructor() {
    private var agentArns: Output<List<String>>? = null

    private var s3BucketArn: Output<String>? = null

    private var s3Config: Output<S3LocationS3ConfigArgs>? = null

    private var s3StorageClass: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("ldfjjaurmbulxvrp")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("pinfulniimhupnph")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("stnkecihqmcbvqdo")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the S3 Bucket.
     */
    @JvmName("geflkoejnegvynyk")
    public suspend fun s3BucketArn(`value`: Output<String>) {
        this.s3BucketArn = value
    }

    /**
     * @param value Configuration block containing information for connecting to S3.
     */
    @JvmName("fhgsouxmyleuxbqx")
    public suspend fun s3Config(`value`: Output<S3LocationS3ConfigArgs>) {
        this.s3Config = value
    }

    /**
     * @param value The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     */
    @JvmName("syhwsbifuwboglmj")
    public suspend fun s3StorageClass(`value`: Output<String>) {
        this.s3StorageClass = value
    }

    /**
     * @param value Prefix to perform actions as source or destination.
     */
    @JvmName("gtcjjxtyhvqoljtk")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gpsveljpftnarbkg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("qucocjamruyirjih")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("ejsymjmqigrmwmud")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the S3 Bucket.
     */
    @JvmName("mwwohbihrigcsfwj")
    public suspend fun s3BucketArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketArn = mapped
    }

    /**
     * @param value Configuration block containing information for connecting to S3.
     */
    @JvmName("xrkxkbtlgphynrln")
    public suspend fun s3Config(`value`: S3LocationS3ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Config = mapped
    }

    /**
     * @param argument Configuration block containing information for connecting to S3.
     */
    @JvmName("dcsstrvothvguyml")
    public suspend fun s3Config(argument: suspend S3LocationS3ConfigArgsBuilder.() -> Unit) {
        val toBeMapped = S3LocationS3ConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Config = mapped
    }

    /**
     * @param value The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     */
    @JvmName("nnlahurndqtbsuby")
    public suspend fun s3StorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3StorageClass = mapped
    }

    /**
     * @param value Prefix to perform actions as source or destination.
     */
    @JvmName("fgjqouojvokrxmnd")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rhouogisaryfcdfc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rxdkbuweswhsexjn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): S3LocationArgs = S3LocationArgs(
        agentArns = agentArns,
        s3BucketArn = s3BucketArn,
        s3Config = s3Config,
        s3StorageClass = s3StorageClass,
        subdirectory = subdirectory,
        tags = tags,
    )
}
