@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.kotlin.outputs.TaskExcludes
import com.pulumi.aws.datasync.kotlin.outputs.TaskIncludes
import com.pulumi.aws.datasync.kotlin.outputs.TaskOptions
import com.pulumi.aws.datasync.kotlin.outputs.TaskSchedule
import com.pulumi.aws.datasync.kotlin.outputs.TaskTaskReportConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.datasync.kotlin.outputs.TaskExcludes.Companion.toKotlin as taskExcludesToKotlin
import com.pulumi.aws.datasync.kotlin.outputs.TaskIncludes.Companion.toKotlin as taskIncludesToKotlin
import com.pulumi.aws.datasync.kotlin.outputs.TaskOptions.Companion.toKotlin as taskOptionsToKotlin
import com.pulumi.aws.datasync.kotlin.outputs.TaskSchedule.Companion.toKotlin as taskScheduleToKotlin
import com.pulumi.aws.datasync.kotlin.outputs.TaskTaskReportConfig.Companion.toKotlin as taskTaskReportConfigToKotlin

/**
 * Builder for [Task].
 */
@PulumiTagMarker
public class TaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TaskArgs = TaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TaskArgsBuilder.() -> Unit) {
        val builder = TaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Task {
        val builtJavaResource = com.pulumi.aws.datasync.Task(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Task(builtJavaResource)
    }
}

/**
 * Manages an AWS DataSync Task, which represents a configuration for synchronization. Starting an execution of these DataSync Tasks (actually synchronizing files) is performed outside of this resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.Task("example", {
 *     destinationLocationArn: destination.arn,
 *     name: "example",
 *     sourceLocationArn: source.arn,
 *     options: {
 *         bytesPerSecond: -1,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.Task("example",
 *     destination_location_arn=destination["arn"],
 *     name="example",
 *     source_location_arn=source["arn"],
 *     options={
 *         "bytes_per_second": -1,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.Task("example", new()
 *     {
 *         DestinationLocationArn = destination.Arn,
 *         Name = "example",
 *         SourceLocationArn = source.Arn,
 *         Options = new Aws.DataSync.Inputs.TaskOptionsArgs
 *         {
 *             BytesPerSecond = -1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewTask(ctx, "example", &datasync.TaskArgs{
 * 			DestinationLocationArn: pulumi.Any(destination.Arn),
 * 			Name:                   pulumi.String("example"),
 * 			SourceLocationArn:      pulumi.Any(source.Arn),
 * 			Options: &datasync.TaskOptionsArgs{
 * 				BytesPerSecond: int(-1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:Task
 *     properties:
 *       destinationLocationArn: ${destination.arn}
 *       name: example
 *       sourceLocationArn: ${source.arn}
 *       options:
 *         bytesPerSecond: -1
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Scheduling
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.Task("example", {
 *     destinationLocationArn: destination.arn,
 *     name: "example",
 *     sourceLocationArn: source.arn,
 *     schedule: {
 *         scheduleExpression: "cron(0 12 ? * SUN,WED *)",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.Task("example",
 *     destination_location_arn=destination["arn"],
 *     name="example",
 *     source_location_arn=source["arn"],
 *     schedule={
 *         "schedule_expression": "cron(0 12 ? * SUN,WED *)",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.Task("example", new()
 *     {
 *         DestinationLocationArn = destination.Arn,
 *         Name = "example",
 *         SourceLocationArn = source.Arn,
 *         Schedule = new Aws.DataSync.Inputs.TaskScheduleArgs
 *         {
 *             ScheduleExpression = "cron(0 12 ? * SUN,WED *)",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewTask(ctx, "example", &datasync.TaskArgs{
 * 			DestinationLocationArn: pulumi.Any(destination.Arn),
 * 			Name:                   pulumi.String("example"),
 * 			SourceLocationArn:      pulumi.Any(source.Arn),
 * 			Schedule: &datasync.TaskScheduleArgs{
 * 				ScheduleExpression: pulumi.String("cron(0 12 ? * SUN,WED *)"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.Task;
 * import com.pulumi.aws.datasync.TaskArgs;
 * import com.pulumi.aws.datasync.inputs.TaskScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Task("example", TaskArgs.builder()
 *             .destinationLocationArn(destination.arn())
 *             .name("example")
 *             .sourceLocationArn(source.arn())
 *             .schedule(TaskScheduleArgs.builder()
 *                 .scheduleExpression("cron(0 12 ? * SUN,WED *)")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:Task
 *     properties:
 *       destinationLocationArn: ${destination.arn}
 *       name: example
 *       sourceLocationArn: ${source.arn}
 *       schedule:
 *         scheduleExpression: cron(0 12 ? * SUN,WED *)
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Filtering
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datasync.Task("example", {
 *     destinationLocationArn: destination.arn,
 *     name: "example",
 *     sourceLocationArn: source.arn,
 *     excludes: {
 *         filterType: "SIMPLE_PATTERN",
 *         value: "/folder1|/folder2",
 *     },
 *     includes: {
 *         filterType: "SIMPLE_PATTERN",
 *         value: "/folder1|/folder2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datasync.Task("example",
 *     destination_location_arn=destination["arn"],
 *     name="example",
 *     source_location_arn=source["arn"],
 *     excludes={
 *         "filter_type": "SIMPLE_PATTERN",
 *         "value": "/folder1|/folder2",
 *     },
 *     includes={
 *         "filter_type": "SIMPLE_PATTERN",
 *         "value": "/folder1|/folder2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataSync.Task("example", new()
 *     {
 *         DestinationLocationArn = destination.Arn,
 *         Name = "example",
 *         SourceLocationArn = source.Arn,
 *         Excludes = new Aws.DataSync.Inputs.TaskExcludesArgs
 *         {
 *             FilterType = "SIMPLE_PATTERN",
 *             Value = "/folder1|/folder2",
 *         },
 *         Includes = new Aws.DataSync.Inputs.TaskIncludesArgs
 *         {
 *             FilterType = "SIMPLE_PATTERN",
 *             Value = "/folder1|/folder2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datasync"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datasync.NewTask(ctx, "example", &datasync.TaskArgs{
 * 			DestinationLocationArn: pulumi.Any(destination.Arn),
 * 			Name:                   pulumi.String("example"),
 * 			SourceLocationArn:      pulumi.Any(source.Arn),
 * 			Excludes: &datasync.TaskExcludesArgs{
 * 				FilterType: pulumi.String("SIMPLE_PATTERN"),
 * 				Value:      pulumi.String("/folder1|/folder2"),
 * 			},
 * 			Includes: &datasync.TaskIncludesArgs{
 * 				FilterType: pulumi.String("SIMPLE_PATTERN"),
 * 				Value:      pulumi.String("/folder1|/folder2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.Task;
 * import com.pulumi.aws.datasync.TaskArgs;
 * import com.pulumi.aws.datasync.inputs.TaskExcludesArgs;
 * import com.pulumi.aws.datasync.inputs.TaskIncludesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Task("example", TaskArgs.builder()
 *             .destinationLocationArn(destination.arn())
 *             .name("example")
 *             .sourceLocationArn(source.arn())
 *             .excludes(TaskExcludesArgs.builder()
 *                 .filterType("SIMPLE_PATTERN")
 *                 .value("/folder1|/folder2")
 *                 .build())
 *             .includes(TaskIncludesArgs.builder()
 *                 .filterType("SIMPLE_PATTERN")
 *                 .value("/folder1|/folder2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datasync:Task
 *     properties:
 *       destinationLocationArn: ${destination.arn}
 *       name: example
 *       sourceLocationArn: ${source.arn}
 *       excludes:
 *         filterType: SIMPLE_PATTERN
 *         value: /folder1|/folder2
 *       includes:
 *         filterType: SIMPLE_PATTERN
 *         value: /folder1|/folder2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datasync_task` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:datasync/task:Task example arn:aws:datasync:us-east-1:123456789012:task/task-12345678901234567
 * ```
 */
public class Task internal constructor(
    override val javaResource: com.pulumi.aws.datasync.Task,
) : KotlinCustomResource(javaResource, TaskMapper) {
    /**
     * Amazon Resource Name (ARN) of the DataSync Task.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
     */
    public val cloudwatchLogGroupArn: Output<String>?
        get() = javaResource.cloudwatchLogGroupArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of destination DataSync Location.
     */
    public val destinationLocationArn: Output<String>
        get() = javaResource.destinationLocationArn().applyValue({ args0 -> args0 })

    /**
     * Filter rules that determines which files to exclude from a task.
     */
    public val excludes: Output<TaskExcludes>?
        get() = javaResource.excludes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    taskExcludesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Filter rules that determines which files to include in a task.
     */
    public val includes: Output<TaskIncludes>?
        get() = javaResource.includes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    taskIncludesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Name of the DataSync Task.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
     */
    public val options: Output<TaskOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    taskOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location.
     */
    public val schedule: Output<TaskSchedule>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    taskScheduleToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of source DataSync Location.
     */
    public val sourceLocationArn: Output<String>
        get() = javaResource.sourceLocationArn().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
     */
    public val taskReportConfig: Output<TaskTaskReportConfig>?
        get() = javaResource.taskReportConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> taskTaskReportConfigToKotlin(args0) })
            }).orElse(null)
        })
}

public object TaskMapper : ResourceMapper<Task> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datasync.Task::class == javaResource::class

    override fun map(javaResource: Resource): Task = Task(
        javaResource as
            com.pulumi.aws.datasync.Task,
    )
}

/**
 * @see [Task].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Task].
 */
public suspend fun task(name: String, block: suspend TaskResourceBuilder.() -> Unit): Task {
    val builder = TaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Task].
 * @param name The _unique_ name of the resulting resource.
 */
public fun task(name: String): Task {
    val builder = TaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
