@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property mountOptions Represents the mount options that are available for DataSync to access an NFS location. See below.
 */
public data class FsxOpenZfsFileSystemProtocolNfsArgs(
    public val mountOptions: Output<FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsArgs =
        com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolNfsArgs.builder()
            .mountOptions(mountOptions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FsxOpenZfsFileSystemProtocolNfsArgs].
 */
@PulumiTagMarker
public class FsxOpenZfsFileSystemProtocolNfsArgsBuilder internal constructor() {
    private var mountOptions: Output<FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs>? = null

    /**
     * @param value Represents the mount options that are available for DataSync to access an NFS location. See below.
     */
    @JvmName("ddrhgadrunvwjlgj")
    public suspend fun mountOptions(`value`: Output<FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs>) {
        this.mountOptions = value
    }

    /**
     * @param value Represents the mount options that are available for DataSync to access an NFS location. See below.
     */
    @JvmName("gtqgaqctuwcfvkjp")
    public suspend fun mountOptions(`value`: FsxOpenZfsFileSystemProtocolNfsMountOptionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param argument Represents the mount options that are available for DataSync to access an NFS location. See below.
     */
    @JvmName("brbrfmaerotuvwbj")
    public suspend fun mountOptions(argument: suspend FsxOpenZfsFileSystemProtocolNfsMountOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FsxOpenZfsFileSystemProtocolNfsMountOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mountOptions = mapped
    }

    internal fun build(): FsxOpenZfsFileSystemProtocolNfsArgs = FsxOpenZfsFileSystemProtocolNfsArgs(
        mountOptions = mountOptions ?: throw PulumiNullFieldException("mountOptions"),
    )
}
