@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolSmbArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property domain Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
 * @property mountOptions Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
 * @property password Password of a user who has permission to access your SVM.
 * @property user Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
 */
public data class LocationFsxOntapFileSystemProtocolSmbArgs(
    public val domain: Output<String>? = null,
    public val mountOptions: Output<LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs>,
    public val password: Output<String>,
    public val user: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolSmbArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolSmbArgs =
        com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolSmbArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .mountOptions(mountOptions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .password(password.applyValue({ args0 -> args0 }))
            .user(user.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationFsxOntapFileSystemProtocolSmbArgs].
 */
@PulumiTagMarker
public class LocationFsxOntapFileSystemProtocolSmbArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var mountOptions: Output<LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs>? = null

    private var password: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
     */
    @JvmName("qcsejtbgthobsxbe")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
     */
    @JvmName("soallhmwoxnpguok")
    public suspend fun mountOptions(`value`: Output<LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs>) {
        this.mountOptions = value
    }

    /**
     * @param value Password of a user who has permission to access your SVM.
     */
    @JvmName("kbscnegmrskofrmf")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
     */
    @JvmName("siocnuquyodotyad")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
     */
    @JvmName("hhgfldynwtrkijbb")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
     */
    @JvmName("yaqumugoihsqjmwj")
    public suspend fun mountOptions(`value`: LocationFsxOntapFileSystemProtocolSmbMountOptionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param argument Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
     */
    @JvmName("metmctdsnugxohjy")
    public suspend fun mountOptions(argument: suspend LocationFsxOntapFileSystemProtocolSmbMountOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LocationFsxOntapFileSystemProtocolSmbMountOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mountOptions = mapped
    }

    /**
     * @param value Password of a user who has permission to access your SVM.
     */
    @JvmName("fmcumddvuatrijnq")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
     */
    @JvmName("dpkmviqqbmpgwaaw")
    public suspend fun user(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): LocationFsxOntapFileSystemProtocolSmbArgs =
        LocationFsxOntapFileSystemProtocolSmbArgs(
            domain = domain,
            mountOptions = mountOptions ?: throw PulumiNullFieldException("mountOptions"),
            password = password ?: throw PulumiNullFieldException("password"),
            user = user ?: throw PulumiNullFieldException("user"),
        )
}
