@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostname The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
 * @property port The port that the NameNode uses to listen to client requests.
 */
public data class LocationHdfsNameNodeArgs(
    public val hostname: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs =
        com.pulumi.aws.datasync.inputs.LocationHdfsNameNodeArgs.builder()
            .hostname(hostname.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationHdfsNameNodeArgs].
 */
@PulumiTagMarker
public class LocationHdfsNameNodeArgsBuilder internal constructor() {
    private var hostname: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
     */
    @JvmName("ctqokaxdfmgsljrc")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value The port that the NameNode uses to listen to client requests.
     */
    @JvmName("boxunbpkbuecvxrx")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
     */
    @JvmName("dxvhdsrufhydrhnm")
    public suspend fun hostname(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value The port that the NameNode uses to listen to client requests.
     */
    @JvmName("hrlbrmdbeqyytuaj")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): LocationHdfsNameNodeArgs = LocationHdfsNameNodeArgs(
        hostname = hostname ?: throw PulumiNullFieldException("hostname"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
