@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.LocationSmbMountOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property version The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
 */
public data class LocationSmbMountOptionsArgs(
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.LocationSmbMountOptionsArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.LocationSmbMountOptionsArgs =
        com.pulumi.aws.datasync.inputs.LocationSmbMountOptionsArgs.builder()
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationSmbMountOptionsArgs].
 */
@PulumiTagMarker
public class LocationSmbMountOptionsArgsBuilder internal constructor() {
    private var version: Output<String>? = null

    /**
     * @param value The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
     */
    @JvmName("edcigouuewxmvtum")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
     */
    @JvmName("chjjnwpnppmtgark")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): LocationSmbMountOptionsArgs = LocationSmbMountOptionsArgs(
        version = version,
    )
}
