@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.TaskScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scheduleExpression Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
 */
public data class TaskScheduleArgs(
    public val scheduleExpression: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.TaskScheduleArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.TaskScheduleArgs =
        com.pulumi.aws.datasync.inputs.TaskScheduleArgs.builder()
            .scheduleExpression(scheduleExpression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskScheduleArgs].
 */
@PulumiTagMarker
public class TaskScheduleArgsBuilder internal constructor() {
    private var scheduleExpression: Output<String>? = null

    /**
     * @param value Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
     */
    @JvmName("rdfhspvbemkgaqqv")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value Specifies the schedule you want your task to use for repeated executions. For more information, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html).
     */
    @JvmName("whddijxgeqnqxsex")
    public suspend fun scheduleExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    internal fun build(): TaskScheduleArgs = TaskScheduleArgs(
        scheduleExpression = scheduleExpression ?: throw PulumiNullFieldException("scheduleExpression"),
    )
}
