@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.TaskTaskReportConfigReportOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deletedOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property skippedOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property transferredOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property verifiedOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
 */
public data class TaskTaskReportConfigReportOverridesArgs(
    public val deletedOverride: Output<String>? = null,
    public val skippedOverride: Output<String>? = null,
    public val transferredOverride: Output<String>? = null,
    public val verifiedOverride: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.TaskTaskReportConfigReportOverridesArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.TaskTaskReportConfigReportOverridesArgs =
        com.pulumi.aws.datasync.inputs.TaskTaskReportConfigReportOverridesArgs.builder()
            .deletedOverride(deletedOverride?.applyValue({ args0 -> args0 }))
            .skippedOverride(skippedOverride?.applyValue({ args0 -> args0 }))
            .transferredOverride(transferredOverride?.applyValue({ args0 -> args0 }))
            .verifiedOverride(verifiedOverride?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskTaskReportConfigReportOverridesArgs].
 */
@PulumiTagMarker
public class TaskTaskReportConfigReportOverridesArgsBuilder internal constructor() {
    private var deletedOverride: Output<String>? = null

    private var skippedOverride: Output<String>? = null

    private var transferredOverride: Output<String>? = null

    private var verifiedOverride: Output<String>? = null

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("tjcowavpsxcslqmn")
    public suspend fun deletedOverride(`value`: Output<String>) {
        this.deletedOverride = value
    }

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("guncqjekkjwxkqwa")
    public suspend fun skippedOverride(`value`: Output<String>) {
        this.skippedOverride = value
    }

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("ivpqmkengsnmdslw")
    public suspend fun transferredOverride(`value`: Output<String>) {
        this.transferredOverride = value
    }

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     * > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
     */
    @JvmName("vvomcftxahvyxyrb")
    public suspend fun verifiedOverride(`value`: Output<String>) {
        this.verifiedOverride = value
    }

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("ojvjnouqmgvnixfw")
    public suspend fun deletedOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletedOverride = mapped
    }

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("fwvpuippbdbmrepf")
    public suspend fun skippedOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skippedOverride = mapped
    }

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("eyfhgjuufschgqtf")
    public suspend fun transferredOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferredOverride = mapped
    }

    /**
     * @param value Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     * > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
     */
    @JvmName("lornoabbmlybokoi")
    public suspend fun verifiedOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedOverride = mapped
    }

    internal fun build(): TaskTaskReportConfigReportOverridesArgs =
        TaskTaskReportConfigReportOverridesArgs(
            deletedOverride = deletedOverride,
            skippedOverride = skippedOverride,
            transferredOverride = transferredOverride,
            verifiedOverride = verifiedOverride,
        )
}
