@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.TaskTaskReportConfigS3DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketAccessRoleArn Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
 * @property s3BucketArn Specifies the ARN of the S3 bucket where DataSync uploads your report.
 * @property subdirectory Specifies a bucket prefix for your report.
 */
public data class TaskTaskReportConfigS3DestinationArgs(
    public val bucketAccessRoleArn: Output<String>,
    public val s3BucketArn: Output<String>,
    public val subdirectory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.TaskTaskReportConfigS3DestinationArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.TaskTaskReportConfigS3DestinationArgs =
        com.pulumi.aws.datasync.inputs.TaskTaskReportConfigS3DestinationArgs.builder()
            .bucketAccessRoleArn(bucketAccessRoleArn.applyValue({ args0 -> args0 }))
            .s3BucketArn(s3BucketArn.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskTaskReportConfigS3DestinationArgs].
 */
@PulumiTagMarker
public class TaskTaskReportConfigS3DestinationArgsBuilder internal constructor() {
    private var bucketAccessRoleArn: Output<String>? = null

    private var s3BucketArn: Output<String>? = null

    private var subdirectory: Output<String>? = null

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
     */
    @JvmName("nyfedrndqfhoeenx")
    public suspend fun bucketAccessRoleArn(`value`: Output<String>) {
        this.bucketAccessRoleArn = value
    }

    /**
     * @param value Specifies the ARN of the S3 bucket where DataSync uploads your report.
     */
    @JvmName("yblwjtfcmnmivcxd")
    public suspend fun s3BucketArn(`value`: Output<String>) {
        this.s3BucketArn = value
    }

    /**
     * @param value Specifies a bucket prefix for your report.
     */
    @JvmName("dwfsmfaxyxitiylb")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
     */
    @JvmName("hhlvnkrcaroyctrh")
    public suspend fun bucketAccessRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketAccessRoleArn = mapped
    }

    /**
     * @param value Specifies the ARN of the S3 bucket where DataSync uploads your report.
     */
    @JvmName("dikqbxvddnwvktmb")
    public suspend fun s3BucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketArn = mapped
    }

    /**
     * @param value Specifies a bucket prefix for your report.
     */
    @JvmName("mqsqmthxnwnkcgod")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    internal fun build(): TaskTaskReportConfigS3DestinationArgs =
        TaskTaskReportConfigS3DestinationArgs(
            bucketAccessRoleArn = bucketAccessRoleArn ?: throw PulumiNullFieldException("bucketAccessRoleArn"),
            s3BucketArn = s3BucketArn ?: throw PulumiNullFieldException("s3BucketArn"),
            subdirectory = subdirectory,
        )
}
