@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupArns List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
 * @property subnetArn Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
 */
public data class EfsLocationEc2Config(
    public val securityGroupArns: List<String>,
    public val subnetArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.EfsLocationEc2Config): EfsLocationEc2Config = EfsLocationEc2Config(
            securityGroupArns = javaType.securityGroupArns().map({ args0 -> args0 }),
            subnetArn = javaType.subnetArn(),
        )
    }
}
