@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property nfs Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
 * @property smb Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
 */
public data class LocationFsxOntapFileSystemProtocol(
    public val nfs: LocationFsxOntapFileSystemProtocolNfs? = null,
    public val smb: LocationFsxOntapFileSystemProtocolSmb? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.LocationFsxOntapFileSystemProtocol): LocationFsxOntapFileSystemProtocol = LocationFsxOntapFileSystemProtocol(
            nfs = javaType.nfs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.datasync.kotlin.outputs.LocationFsxOntapFileSystemProtocolNfs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            smb = javaType.smb().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.datasync.kotlin.outputs.LocationFsxOntapFileSystemProtocolSmb.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
