@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domain Fully qualified domain name of the Microsoft Active Directory (AD) that your storage virtual machine belongs to.
 * @property mountOptions Mount options that are available for DataSync to access an SMB location. See SMB Mount Options below.
 * @property password Password of a user who has permission to access your SVM.
 * @property user Username that can mount the location and access the files, folders, and metadata that you need in the SVM.
 */
public data class LocationFsxOntapFileSystemProtocolSmb(
    public val domain: String? = null,
    public val mountOptions: LocationFsxOntapFileSystemProtocolSmbMountOptions,
    public val password: String,
    public val user: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.LocationFsxOntapFileSystemProtocolSmb): LocationFsxOntapFileSystemProtocolSmb = LocationFsxOntapFileSystemProtocolSmb(
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            mountOptions = javaType.mountOptions().let({ args0 ->
                com.pulumi.aws.datasync.kotlin.outputs.LocationFsxOntapFileSystemProtocolSmbMountOptions.Companion.toKotlin(args0)
            }),
            password = javaType.password(),
            user = javaType.user(),
        )
    }
}
