@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataTransferProtection The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
 * @property rpcProtection The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
 */
public data class LocationHdfsQopConfiguration(
    public val dataTransferProtection: String? = null,
    public val rpcProtection: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.LocationHdfsQopConfiguration): LocationHdfsQopConfiguration = LocationHdfsQopConfiguration(
            dataTransferProtection = javaType.dataTransferProtection().map({ args0 -> args0 }).orElse(null),
            rpcProtection = javaType.rpcProtection().map({ args0 -> args0 }).orElse(null),
        )
    }
}
