@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property filterType The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
 * @property value A single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
 */
public data class TaskIncludes(
    public val filterType: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.TaskIncludes): TaskIncludes =
            TaskIncludes(
                filterType = javaType.filterType().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            )
    }
}
