@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deletedOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property skippedOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to skip during your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property transferredOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property verifiedOverride Specifies the level of reporting for the files, objects, and directories that DataSync attempted to verify at the end of your transfer. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * > **NOTE:** If any `report_overrides` are set to the same value as `task_report_config.report_level`, they will always be flagged as changed. Only set overrides to a value that differs from `task_report_config.report_level`.
 */
public data class TaskTaskReportConfigReportOverrides(
    public val deletedOverride: String? = null,
    public val skippedOverride: String? = null,
    public val transferredOverride: String? = null,
    public val verifiedOverride: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.TaskTaskReportConfigReportOverrides): TaskTaskReportConfigReportOverrides = TaskTaskReportConfigReportOverrides(
            deletedOverride = javaType.deletedOverride().map({ args0 -> args0 }).orElse(null),
            skippedOverride = javaType.skippedOverride().map({ args0 -> args0 }).orElse(null),
            transferredOverride = javaType.transferredOverride().map({ args0 -> args0 }).orElse(null),
            verifiedOverride = javaType.verifiedOverride().map({ args0 -> args0 }).orElse(null),
        )
    }
}
