@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketAccessRoleArn Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your S3 bucket.
 * @property s3BucketArn Specifies the ARN of the S3 bucket where DataSync uploads your report.
 * @property subdirectory Specifies a bucket prefix for your report.
 */
public data class TaskTaskReportConfigS3Destination(
    public val bucketAccessRoleArn: String,
    public val s3BucketArn: String,
    public val subdirectory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.TaskTaskReportConfigS3Destination): TaskTaskReportConfigS3Destination = TaskTaskReportConfigS3Destination(
            bucketAccessRoleArn = javaType.bucketAccessRoleArn(),
            s3BucketArn = javaType.s3BucketArn(),
            subdirectory = javaType.subdirectory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
