@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin

import com.pulumi.aws.datazone.kotlin.outputs.DomainSingleSignOn
import com.pulumi.aws.datazone.kotlin.outputs.DomainTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.datazone.kotlin.outputs.DomainSingleSignOn.Companion.toKotlin as domainSingleSignOnToKotlin
import com.pulumi.aws.datazone.kotlin.outputs.DomainTimeouts.Companion.toKotlin as domainTimeoutsToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.datazone.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS DataZone Domain.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const domainExecutionRole = new aws.iam.Role("domain_execution_role", {
 *     name: "my_domain_execution_role",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [
 *             {
 *                 Action: [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 Effect: "Allow",
 *                 Principal: {
 *                     Service: "datazone.amazonaws.com",
 *                 },
 *             },
 *             {
 *                 Action: [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 Effect: "Allow",
 *                 Principal: {
 *                     Service: "cloudformation.amazonaws.com",
 *                 },
 *             },
 *         ],
 *     }),
 *     inlinePolicies: [{
 *         name: "domain_execution_policy",
 *         policy: JSON.stringify({
 *             Version: "2012-10-17",
 *             Statement: [{
 *                 Action: [
 *                     "datazone:*",
 *                     "ram:*",
 *                     "sso:*",
 *                     "kms:*",
 *                 ],
 *                 Effect: "Allow",
 *                 Resource: "*",
 *             }],
 *         }),
 *     }],
 * });
 * const example = new aws.datazone.Domain("example", {
 *     name: "example",
 *     domainExecutionRole: domainExecutionRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * domain_execution_role = aws.iam.Role("domain_execution_role",
 *     name="my_domain_execution_role",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [
 *             {
 *                 "Action": [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                     "Service": "datazone.amazonaws.com",
 *                 },
 *             },
 *             {
 *                 "Action": [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                     "Service": "cloudformation.amazonaws.com",
 *                 },
 *             },
 *         ],
 *     }),
 *     inline_policies=[{
 *         "name": "domain_execution_policy",
 *         "policy": json.dumps({
 *             "version": "2012-10-17",
 *             "statement": [{
 *                 "action": [
 *                     "datazone:*",
 *                     "ram:*",
 *                     "sso:*",
 *                     "kms:*",
 *                 ],
 *                 "effect": "Allow",
 *                 "resource": "*",
 *             }],
 *         }),
 *     }])
 * example = aws.datazone.Domain("example",
 *     name="example",
 *     domain_execution_role=domain_execution_role.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainExecutionRole = new Aws.Iam.Role("domain_execution_role", new()
 *     {
 *         Name = "my_domain_execution_role",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "sts:AssumeRole",
 *                         "sts:TagSession",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "datazone.amazonaws.com",
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "sts:AssumeRole",
 *                         "sts:TagSession",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "cloudformation.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *         InlinePolicies = new[]
 *         {
 *             new Aws.Iam.Inputs.RoleInlinePolicyArgs
 *             {
 *                 Name = "domain_execution_policy",
 *                 Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *                 {
 *                     ["Version"] = "2012-10-17",
 *                     ["Statement"] = new[]
 *                     {
 *                         new Dictionary<string, object?>
 *                         {
 *                             ["Action"] = new[]
 *                             {
 *                                 "datazone:*",
 *                                 "ram:*",
 *                                 "sso:*",
 *                                 "kms:*",
 *                             },
 *                             ["Effect"] = "Allow",
 *                             ["Resource"] = "*",
 *                         },
 *                     },
 *                 }),
 *             },
 *         },
 *     });
 *     var example = new Aws.DataZone.Domain("example", new()
 *     {
 *         Name = "example",
 *         DomainExecutionRole = domainExecutionRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datazone"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"sts:AssumeRole",
 * 						"sts:TagSession",
 * 					},
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "datazone.amazonaws.com",
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"sts:AssumeRole",
 * 						"sts:TagSession",
 * 					},
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "cloudformation.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"datazone:*",
 * 						"ram:*",
 * 						"sso:*",
 * 						"kms:*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json1 := string(tmpJSON1)
 * 		domainExecutionRole, err := iam.NewRole(ctx, "domain_execution_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("my_domain_execution_role"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 			InlinePolicies: iam.RoleInlinePolicyArray{
 * 				&iam.RoleInlinePolicyArgs{
 * 					Name:   pulumi.String("domain_execution_policy"),
 * 					Policy: pulumi.String(json1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = datazone.NewDomain(ctx, "example", &datazone.DomainArgs{
 * 			Name:                pulumi.String("example"),
 * 			DomainExecutionRole: domainExecutionRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import com.pulumi.aws.datazone.Domain;
 * import com.pulumi.aws.datazone.DomainArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainExecutionRole = new Role("domainExecutionRole", RoleArgs.builder()
 *             .name("my_domain_execution_role")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "sts:AssumeRole",
 *                                 "sts:TagSession"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "datazone.amazonaws.com")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "sts:AssumeRole",
 *                                 "sts:TagSession"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "cloudformation.amazonaws.com")
 *                             ))
 *                         )
 *                     ))
 *                 )))
 *             .inlinePolicies(RoleInlinePolicyArgs.builder()
 *                 .name("domain_execution_policy")
 *                 .policy(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "datazone:*",
 *                                 "ram:*",
 *                                 "sso:*",
 *                                 "kms:*"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Resource", "*")
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new Domain("example", DomainArgs.builder()
 *             .name("example")
 *             .domainExecutionRole(domainExecutionRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   domainExecutionRole:
 *     type: aws:iam:Role
 *     name: domain_execution_role
 *     properties:
 *       name: my_domain_execution_role
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - sts:AssumeRole
 *                 - sts:TagSession
 *               Effect: Allow
 *               Principal:
 *                 Service: datazone.amazonaws.com
 *             - Action:
 *                 - sts:AssumeRole
 *                 - sts:TagSession
 *               Effect: Allow
 *               Principal:
 *                 Service: cloudformation.amazonaws.com
 *       inlinePolicies:
 *         - name: domain_execution_policy
 *           policy:
 *             fn::toJSON:
 *               Version: 2012-10-17
 *               Statement:
 *                 - Action:
 *                     - datazone:*
 *                     - ram:*
 *                     - sso:*
 *                     - kms:*
 *                   Effect: Allow
 *                   Resource: '*'
 *   example:
 *     type: aws:datazone:Domain
 *     properties:
 *       name: example
 *       domainExecutionRole: ${domainExecutionRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DataZone Domain using the `domain_id`. For example:
 * ```sh
 * $ pulumi import aws:datazone/domain:Domain example domain-id-12345678
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.datazone.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * ARN of the Domain.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the Domain.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the role used by DataZone to configure the Domain.
     * The following arguments are optional:
     */
    public val domainExecutionRole: Output<String>
        get() = javaResource.domainExecutionRole().applyValue({ args0 -> args0 })

    /**
     * ARN of the KMS key used to encrypt the Amazon DataZone domain, metadata and reporting data.
     */
    public val kmsKeyIdentifier: Output<String>?
        get() = javaResource.kmsKeyIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the Domain.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * URL of the data portal for the Domain.
     */
    public val portalUrl: Output<String>
        get() = javaResource.portalUrl().applyValue({ args0 -> args0 })

    /**
     * Single sign on options, used to [enable AWS IAM Identity Center](https://docs.aws.amazon.com/datazone/latest/userguide/enable-IAM-identity-center-for-datazone.html) for DataZone.
     */
    public val singleSignOn: Output<DomainSingleSignOn>?
        get() = javaResource.singleSignOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainSingleSignOnToKotlin(args0)
                })
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<DomainTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datazone.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.datazone.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
