@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin

import com.pulumi.aws.datazone.DomainArgs.builder
import com.pulumi.aws.datazone.kotlin.inputs.DomainSingleSignOnArgs
import com.pulumi.aws.datazone.kotlin.inputs.DomainSingleSignOnArgsBuilder
import com.pulumi.aws.datazone.kotlin.inputs.DomainTimeoutsArgs
import com.pulumi.aws.datazone.kotlin.inputs.DomainTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS DataZone Domain.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const domainExecutionRole = new aws.iam.Role("domain_execution_role", {
 *     name: "my_domain_execution_role",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [
 *             {
 *                 Action: [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 Effect: "Allow",
 *                 Principal: {
 *                     Service: "datazone.amazonaws.com",
 *                 },
 *             },
 *             {
 *                 Action: [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 Effect: "Allow",
 *                 Principal: {
 *                     Service: "cloudformation.amazonaws.com",
 *                 },
 *             },
 *         ],
 *     }),
 *     inlinePolicies: [{
 *         name: "domain_execution_policy",
 *         policy: JSON.stringify({
 *             Version: "2012-10-17",
 *             Statement: [{
 *                 Action: [
 *                     "datazone:*",
 *                     "ram:*",
 *                     "sso:*",
 *                     "kms:*",
 *                 ],
 *                 Effect: "Allow",
 *                 Resource: "*",
 *             }],
 *         }),
 *     }],
 * });
 * const example = new aws.datazone.Domain("example", {
 *     name: "example",
 *     domainExecutionRole: domainExecutionRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * domain_execution_role = aws.iam.Role("domain_execution_role",
 *     name="my_domain_execution_role",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [
 *             {
 *                 "Action": [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                     "Service": "datazone.amazonaws.com",
 *                 },
 *             },
 *             {
 *                 "Action": [
 *                     "sts:AssumeRole",
 *                     "sts:TagSession",
 *                 ],
 *                 "Effect": "Allow",
 *                 "Principal": {
 *                     "Service": "cloudformation.amazonaws.com",
 *                 },
 *             },
 *         ],
 *     }),
 *     inline_policies=[{
 *         "name": "domain_execution_policy",
 *         "policy": json.dumps({
 *             "version": "2012-10-17",
 *             "statement": [{
 *                 "action": [
 *                     "datazone:*",
 *                     "ram:*",
 *                     "sso:*",
 *                     "kms:*",
 *                 ],
 *                 "effect": "Allow",
 *                 "resource": "*",
 *             }],
 *         }),
 *     }])
 * example = aws.datazone.Domain("example",
 *     name="example",
 *     domain_execution_role=domain_execution_role.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainExecutionRole = new Aws.Iam.Role("domain_execution_role", new()
 *     {
 *         Name = "my_domain_execution_role",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "sts:AssumeRole",
 *                         "sts:TagSession",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "datazone.amazonaws.com",
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "sts:AssumeRole",
 *                         "sts:TagSession",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "cloudformation.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *         InlinePolicies = new[]
 *         {
 *             new Aws.Iam.Inputs.RoleInlinePolicyArgs
 *             {
 *                 Name = "domain_execution_policy",
 *                 Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *                 {
 *                     ["Version"] = "2012-10-17",
 *                     ["Statement"] = new[]
 *                     {
 *                         new Dictionary<string, object?>
 *                         {
 *                             ["Action"] = new[]
 *                             {
 *                                 "datazone:*",
 *                                 "ram:*",
 *                                 "sso:*",
 *                                 "kms:*",
 *                             },
 *                             ["Effect"] = "Allow",
 *                             ["Resource"] = "*",
 *                         },
 *                     },
 *                 }),
 *             },
 *         },
 *     });
 *     var example = new Aws.DataZone.Domain("example", new()
 *     {
 *         Name = "example",
 *         DomainExecutionRole = domainExecutionRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datazone"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"sts:AssumeRole",
 * 						"sts:TagSession",
 * 					},
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "datazone.amazonaws.com",
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"sts:AssumeRole",
 * 						"sts:TagSession",
 * 					},
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "cloudformation.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"datazone:*",
 * 						"ram:*",
 * 						"sso:*",
 * 						"kms:*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json1 := string(tmpJSON1)
 * 		domainExecutionRole, err := iam.NewRole(ctx, "domain_execution_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("my_domain_execution_role"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 			InlinePolicies: iam.RoleInlinePolicyArray{
 * 				&iam.RoleInlinePolicyArgs{
 * 					Name:   pulumi.String("domain_execution_policy"),
 * 					Policy: pulumi.String(json1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = datazone.NewDomain(ctx, "example", &datazone.DomainArgs{
 * 			Name:                pulumi.String("example"),
 * 			DomainExecutionRole: domainExecutionRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import com.pulumi.aws.datazone.Domain;
 * import com.pulumi.aws.datazone.DomainArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainExecutionRole = new Role("domainExecutionRole", RoleArgs.builder()
 *             .name("my_domain_execution_role")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "sts:AssumeRole",
 *                                 "sts:TagSession"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "datazone.amazonaws.com")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "sts:AssumeRole",
 *                                 "sts:TagSession"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "cloudformation.amazonaws.com")
 *                             ))
 *                         )
 *                     ))
 *                 )))
 *             .inlinePolicies(RoleInlinePolicyArgs.builder()
 *                 .name("domain_execution_policy")
 *                 .policy(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "datazone:*",
 *                                 "ram:*",
 *                                 "sso:*",
 *                                 "kms:*"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Resource", "*")
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new Domain("example", DomainArgs.builder()
 *             .name("example")
 *             .domainExecutionRole(domainExecutionRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   domainExecutionRole:
 *     type: aws:iam:Role
 *     name: domain_execution_role
 *     properties:
 *       name: my_domain_execution_role
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - sts:AssumeRole
 *                 - sts:TagSession
 *               Effect: Allow
 *               Principal:
 *                 Service: datazone.amazonaws.com
 *             - Action:
 *                 - sts:AssumeRole
 *                 - sts:TagSession
 *               Effect: Allow
 *               Principal:
 *                 Service: cloudformation.amazonaws.com
 *       inlinePolicies:
 *         - name: domain_execution_policy
 *           policy:
 *             fn::toJSON:
 *               Version: 2012-10-17
 *               Statement:
 *                 - Action:
 *                     - datazone:*
 *                     - ram:*
 *                     - sso:*
 *                     - kms:*
 *                   Effect: Allow
 *                   Resource: '*'
 *   example:
 *     type: aws:datazone:Domain
 *     properties:
 *       name: example
 *       domainExecutionRole: ${domainExecutionRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DataZone Domain using the `domain_id`. For example:
 * ```sh
 * $ pulumi import aws:datazone/domain:Domain example domain-id-12345678
 * ```
 * @property description Description of the Domain.
 * @property domainExecutionRole ARN of the role used by DataZone to configure the Domain.
 * The following arguments are optional:
 * @property kmsKeyIdentifier ARN of the KMS key used to encrypt the Amazon DataZone domain, metadata and reporting data.
 * @property name Name of the Domain.
 * @property singleSignOn Single sign on options, used to [enable AWS IAM Identity Center](https://docs.aws.amazon.com/datazone/latest/userguide/enable-IAM-identity-center-for-datazone.html) for DataZone.
 * @property tags
 * @property timeouts
 */
public data class DomainArgs(
    public val description: Output<String>? = null,
    public val domainExecutionRole: Output<String>? = null,
    public val kmsKeyIdentifier: Output<String>? = null,
    public val name: Output<String>? = null,
    public val singleSignOn: Output<DomainSingleSignOnArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<DomainTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.datazone.DomainArgs> {
    override fun toJava(): com.pulumi.aws.datazone.DomainArgs =
        com.pulumi.aws.datazone.DomainArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .domainExecutionRole(domainExecutionRole?.applyValue({ args0 -> args0 }))
            .kmsKeyIdentifier(kmsKeyIdentifier?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .singleSignOn(singleSignOn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var domainExecutionRole: Output<String>? = null

    private var kmsKeyIdentifier: Output<String>? = null

    private var name: Output<String>? = null

    private var singleSignOn: Output<DomainSingleSignOnArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<DomainTimeoutsArgs>? = null

    /**
     * @param value Description of the Domain.
     */
    @JvmName("xfgifpbjuswqspil")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ARN of the role used by DataZone to configure the Domain.
     * The following arguments are optional:
     */
    @JvmName("btwooqrvxgeodhes")
    public suspend fun domainExecutionRole(`value`: Output<String>) {
        this.domainExecutionRole = value
    }

    /**
     * @param value ARN of the KMS key used to encrypt the Amazon DataZone domain, metadata and reporting data.
     */
    @JvmName("eoojsxpruhhoaesl")
    public suspend fun kmsKeyIdentifier(`value`: Output<String>) {
        this.kmsKeyIdentifier = value
    }

    /**
     * @param value Name of the Domain.
     */
    @JvmName("ydvckbbqvxtxrluq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Single sign on options, used to [enable AWS IAM Identity Center](https://docs.aws.amazon.com/datazone/latest/userguide/enable-IAM-identity-center-for-datazone.html) for DataZone.
     */
    @JvmName("dsyyaqjhxcmjakog")
    public suspend fun singleSignOn(`value`: Output<DomainSingleSignOnArgs>) {
        this.singleSignOn = value
    }

    /**
     * @param value
     */
    @JvmName("wvfyobefcjernhcf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("sxdjrtrikgcieimb")
    public suspend fun timeouts(`value`: Output<DomainTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Description of the Domain.
     */
    @JvmName("jjbgtetwpajfwwns")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ARN of the role used by DataZone to configure the Domain.
     * The following arguments are optional:
     */
    @JvmName("myyrpsjdhbawtupl")
    public suspend fun domainExecutionRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainExecutionRole = mapped
    }

    /**
     * @param value ARN of the KMS key used to encrypt the Amazon DataZone domain, metadata and reporting data.
     */
    @JvmName("rtrhkxrjgutkyygb")
    public suspend fun kmsKeyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyIdentifier = mapped
    }

    /**
     * @param value Name of the Domain.
     */
    @JvmName("pqwpxnlhiahqqlro")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Single sign on options, used to [enable AWS IAM Identity Center](https://docs.aws.amazon.com/datazone/latest/userguide/enable-IAM-identity-center-for-datazone.html) for DataZone.
     */
    @JvmName("xrjoqmkpkhitepkk")
    public suspend fun singleSignOn(`value`: DomainSingleSignOnArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleSignOn = mapped
    }

    /**
     * @param argument Single sign on options, used to [enable AWS IAM Identity Center](https://docs.aws.amazon.com/datazone/latest/userguide/enable-IAM-identity-center-for-datazone.html) for DataZone.
     */
    @JvmName("hmrkylemawfnjcgy")
    public suspend fun singleSignOn(argument: suspend DomainSingleSignOnArgsBuilder.() -> Unit) {
        val toBeMapped = DomainSingleSignOnArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.singleSignOn = mapped
    }

    /**
     * @param value
     */
    @JvmName("bikggftjpbmpaivd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("otxgxllukysgjexa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("jsludvkuxnslsrop")
    public suspend fun timeouts(`value`: DomainTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pnunsjxwtgecdyab")
    public suspend fun timeouts(argument: suspend DomainTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        description = description,
        domainExecutionRole = domainExecutionRole,
        kmsKeyIdentifier = kmsKeyIdentifier,
        name = name,
        singleSignOn = singleSignOn,
        tags = tags,
        timeouts = timeouts,
    )
}
