@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [EnvironmentBlueprintConfiguration].
 */
@PulumiTagMarker
public class EnvironmentBlueprintConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentBlueprintConfigurationArgs = EnvironmentBlueprintConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentBlueprintConfigurationArgsBuilder.() -> Unit) {
        val builder = EnvironmentBlueprintConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnvironmentBlueprintConfiguration {
        val builtJavaResource =
            com.pulumi.aws.datazone.EnvironmentBlueprintConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnvironmentBlueprintConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS DataZone Environment Blueprint Configuration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datazone.Domain("example", {
 *     name: "example_domain",
 *     domainExecutionRole: domainExecutionRole.arn,
 * });
 * const defaultDataLake = aws.datazone.getEnvironmentBlueprintOutput({
 *     domainId: example.id,
 *     name: "DefaultDataLake",
 *     managed: true,
 * });
 * const exampleEnvironmentBlueprintConfiguration = new aws.datazone.EnvironmentBlueprintConfiguration("example", {
 *     domainId: example.id,
 *     environmentBlueprintId: defaultDataLake.apply(defaultDataLake => defaultDataLake.id),
 *     enabledRegions: ["us-east-1"],
 *     regionalParameters: {
 *         "us-east-1": {
 *             s3Location: "s3://my-amazon-datazone-bucket",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datazone.Domain("example",
 *     name="example_domain",
 *     domain_execution_role=domain_execution_role["arn"])
 * default_data_lake = aws.datazone.get_environment_blueprint_output(domain_id=example.id,
 *     name="DefaultDataLake",
 *     managed=True)
 * example_environment_blueprint_configuration = aws.datazone.EnvironmentBlueprintConfiguration("example",
 *     domain_id=example.id,
 *     environment_blueprint_id=default_data_lake.id,
 *     enabled_regions=["us-east-1"],
 *     regional_parameters={
 *         "us-east-1": {
 *             "s3Location": "s3://my-amazon-datazone-bucket",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataZone.Domain("example", new()
 *     {
 *         Name = "example_domain",
 *         DomainExecutionRole = domainExecutionRole.Arn,
 *     });
 *     var defaultDataLake = Aws.DataZone.GetEnvironmentBlueprint.Invoke(new()
 *     {
 *         DomainId = example.Id,
 *         Name = "DefaultDataLake",
 *         Managed = true,
 *     });
 *     var exampleEnvironmentBlueprintConfiguration = new Aws.DataZone.EnvironmentBlueprintConfiguration("example", new()
 *     {
 *         DomainId = example.Id,
 *         EnvironmentBlueprintId = defaultDataLake.Apply(getEnvironmentBlueprintResult => getEnvironmentBlueprintResult.Id),
 *         EnabledRegions = new[]
 *         {
 *             "us-east-1",
 *         },
 *         RegionalParameters =
 *         {
 *             { "us-east-1",
 *             {
 *                 { "s3Location", "s3://my-amazon-datazone-bucket" },
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datazone"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := datazone.NewDomain(ctx, "example", &datazone.DomainArgs{
 * 			Name:                pulumi.String("example_domain"),
 * 			DomainExecutionRole: pulumi.Any(domainExecutionRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDataLake := datazone.GetEnvironmentBlueprintOutput(ctx, datazone.GetEnvironmentBlueprintOutputArgs{
 * 			DomainId: example.ID(),
 * 			Name:     pulumi.String("DefaultDataLake"),
 * 			Managed:  pulumi.Bool(true),
 * 		}, nil)
 * 		_, err = datazone.NewEnvironmentBlueprintConfiguration(ctx, "example", &datazone.EnvironmentBlueprintConfigurationArgs{
 * 			DomainId: example.ID(),
 * 			EnvironmentBlueprintId: pulumi.String(defaultDataLake.ApplyT(func(defaultDataLake datazone.GetEnvironmentBlueprintResult) (*string, error) {
 * 				return &defaultDataLake.Id, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			EnabledRegions: pulumi.StringArray{
 * 				pulumi.String("us-east-1"),
 * 			},
 * 			RegionalParameters: pulumi.StringMapMap{
 * 				"us-east-1": pulumi.StringMap{
 * 					"s3Location": pulumi.String("s3://my-amazon-datazone-bucket"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datazone.Domain;
 * import com.pulumi.aws.datazone.DomainArgs;
 * import com.pulumi.aws.datazone.DatazoneFunctions;
 * import com.pulumi.aws.datazone.inputs.GetEnvironmentBlueprintArgs;
 * import com.pulumi.aws.datazone.EnvironmentBlueprintConfiguration;
 * import com.pulumi.aws.datazone.EnvironmentBlueprintConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .name("example_domain")
 *             .domainExecutionRole(domainExecutionRole.arn())
 *             .build());
 *         final var defaultDataLake = DatazoneFunctions.getEnvironmentBlueprint(GetEnvironmentBlueprintArgs.builder()
 *             .domainId(example.id())
 *             .name("DefaultDataLake")
 *             .managed(true)
 *             .build());
 *         var exampleEnvironmentBlueprintConfiguration = new EnvironmentBlueprintConfiguration("exampleEnvironmentBlueprintConfiguration", EnvironmentBlueprintConfigurationArgs.builder()
 *             .domainId(example.id())
 *             .environmentBlueprintId(defaultDataLake.applyValue(getEnvironmentBlueprintResult -> getEnvironmentBlueprintResult).applyValue(defaultDataLake -> defaultDataLake.applyValue(getEnvironmentBlueprintResult -> getEnvironmentBlueprintResult.id())))
 *             .enabledRegions("us-east-1")
 *             .regionalParameters(Map.of("us-east-1", Map.of("s3Location", "s3://my-amazon-datazone-bucket")))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datazone:Domain
 *     properties:
 *       name: example_domain
 *       domainExecutionRole: ${domainExecutionRole.arn}
 *   exampleEnvironmentBlueprintConfiguration:
 *     type: aws:datazone:EnvironmentBlueprintConfiguration
 *     name: example
 *     properties:
 *       domainId: ${example.id}
 *       environmentBlueprintId: ${defaultDataLake.id}
 *       enabledRegions:
 *         - us-east-1
 *       regionalParameters:
 *         us-east-1:
 *           s3Location: s3://my-amazon-datazone-bucket
 * variables:
 *   defaultDataLake:
 *     fn::invoke:
 *       Function: aws:datazone:getEnvironmentBlueprint
 *       Arguments:
 *         domainId: ${example.id}
 *         name: DefaultDataLake
 *         managed: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DataZone Environment Blueprint Configuration using the `domain_id` and `environment_blueprint_id`, separated by a `/`. For example:
 * ```sh
 * $ pulumi import aws:datazone/environmentBlueprintConfiguration:EnvironmentBlueprintConfiguration example domain-id-12345/environment-blueprint-id-54321
 * ```
 */
public class EnvironmentBlueprintConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.datazone.EnvironmentBlueprintConfiguration,
) : KotlinCustomResource(javaResource, EnvironmentBlueprintConfigurationMapper) {
    /**
     * ID of the Domain.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * Regions in which the blueprint is enabled
     * The following arguments are optional:
     */
    public val enabledRegions: Output<List<String>>
        get() = javaResource.enabledRegions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ID of the Environment Blueprint
     */
    public val environmentBlueprintId: Output<String>
        get() = javaResource.environmentBlueprintId().applyValue({ args0 -> args0 })

    /**
     * ARN of the manage access role with which this blueprint is created.
     */
    public val manageAccessRoleArn: Output<String>?
        get() = javaResource.manageAccessRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the provisioning role with which this blueprint is created.
     */
    public val provisioningRoleArn: Output<String>?
        get() = javaResource.provisioningRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Parameters for each region in which the blueprint is enabled
     */
    public val regionalParameters: Output<Map<String, Map<String, String>>>?
        get() = javaResource.regionalParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.map({ args0 ->
                            args0.key.to(args0.value)
                        }).toMap(),
                    )
                }).toMap()
            }).orElse(null)
        })
}

public object EnvironmentBlueprintConfigurationMapper :
    ResourceMapper<EnvironmentBlueprintConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datazone.EnvironmentBlueprintConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentBlueprintConfiguration =
        EnvironmentBlueprintConfiguration(
            javaResource as
                com.pulumi.aws.datazone.EnvironmentBlueprintConfiguration,
        )
}

/**
 * @see [EnvironmentBlueprintConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentBlueprintConfiguration].
 */
public suspend fun environmentBlueprintConfiguration(
    name: String,
    block: suspend EnvironmentBlueprintConfigurationResourceBuilder.() -> Unit,
): EnvironmentBlueprintConfiguration {
    val builder = EnvironmentBlueprintConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentBlueprintConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentBlueprintConfiguration(name: String): EnvironmentBlueprintConfiguration {
    val builder = EnvironmentBlueprintConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
