@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin

import com.pulumi.aws.datazone.EnvironmentBlueprintConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS DataZone Environment Blueprint Configuration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.datazone.Domain("example", {
 *     name: "example_domain",
 *     domainExecutionRole: domainExecutionRole.arn,
 * });
 * const defaultDataLake = aws.datazone.getEnvironmentBlueprintOutput({
 *     domainId: example.id,
 *     name: "DefaultDataLake",
 *     managed: true,
 * });
 * const exampleEnvironmentBlueprintConfiguration = new aws.datazone.EnvironmentBlueprintConfiguration("example", {
 *     domainId: example.id,
 *     environmentBlueprintId: defaultDataLake.apply(defaultDataLake => defaultDataLake.id),
 *     enabledRegions: ["us-east-1"],
 *     regionalParameters: {
 *         "us-east-1": {
 *             s3Location: "s3://my-amazon-datazone-bucket",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.datazone.Domain("example",
 *     name="example_domain",
 *     domain_execution_role=domain_execution_role["arn"])
 * default_data_lake = aws.datazone.get_environment_blueprint_output(domain_id=example.id,
 *     name="DefaultDataLake",
 *     managed=True)
 * example_environment_blueprint_configuration = aws.datazone.EnvironmentBlueprintConfiguration("example",
 *     domain_id=example.id,
 *     environment_blueprint_id=default_data_lake.id,
 *     enabled_regions=["us-east-1"],
 *     regional_parameters={
 *         "us-east-1": {
 *             "s3Location": "s3://my-amazon-datazone-bucket",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataZone.Domain("example", new()
 *     {
 *         Name = "example_domain",
 *         DomainExecutionRole = domainExecutionRole.Arn,
 *     });
 *     var defaultDataLake = Aws.DataZone.GetEnvironmentBlueprint.Invoke(new()
 *     {
 *         DomainId = example.Id,
 *         Name = "DefaultDataLake",
 *         Managed = true,
 *     });
 *     var exampleEnvironmentBlueprintConfiguration = new Aws.DataZone.EnvironmentBlueprintConfiguration("example", new()
 *     {
 *         DomainId = example.Id,
 *         EnvironmentBlueprintId = defaultDataLake.Apply(getEnvironmentBlueprintResult => getEnvironmentBlueprintResult.Id),
 *         EnabledRegions = new[]
 *         {
 *             "us-east-1",
 *         },
 *         RegionalParameters =
 *         {
 *             { "us-east-1",
 *             {
 *                 { "s3Location", "s3://my-amazon-datazone-bucket" },
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datazone"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := datazone.NewDomain(ctx, "example", &datazone.DomainArgs{
 * 			Name:                pulumi.String("example_domain"),
 * 			DomainExecutionRole: pulumi.Any(domainExecutionRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDataLake := datazone.GetEnvironmentBlueprintOutput(ctx, datazone.GetEnvironmentBlueprintOutputArgs{
 * 			DomainId: example.ID(),
 * 			Name:     pulumi.String("DefaultDataLake"),
 * 			Managed:  pulumi.Bool(true),
 * 		}, nil)
 * 		_, err = datazone.NewEnvironmentBlueprintConfiguration(ctx, "example", &datazone.EnvironmentBlueprintConfigurationArgs{
 * 			DomainId: example.ID(),
 * 			EnvironmentBlueprintId: pulumi.String(defaultDataLake.ApplyT(func(defaultDataLake datazone.GetEnvironmentBlueprintResult) (*string, error) {
 * 				return &defaultDataLake.Id, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			EnabledRegions: pulumi.StringArray{
 * 				pulumi.String("us-east-1"),
 * 			},
 * 			RegionalParameters: pulumi.StringMapMap{
 * 				"us-east-1": pulumi.StringMap{
 * 					"s3Location": pulumi.String("s3://my-amazon-datazone-bucket"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datazone.Domain;
 * import com.pulumi.aws.datazone.DomainArgs;
 * import com.pulumi.aws.datazone.DatazoneFunctions;
 * import com.pulumi.aws.datazone.inputs.GetEnvironmentBlueprintArgs;
 * import com.pulumi.aws.datazone.EnvironmentBlueprintConfiguration;
 * import com.pulumi.aws.datazone.EnvironmentBlueprintConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .name("example_domain")
 *             .domainExecutionRole(domainExecutionRole.arn())
 *             .build());
 *         final var defaultDataLake = DatazoneFunctions.getEnvironmentBlueprint(GetEnvironmentBlueprintArgs.builder()
 *             .domainId(example.id())
 *             .name("DefaultDataLake")
 *             .managed(true)
 *             .build());
 *         var exampleEnvironmentBlueprintConfiguration = new EnvironmentBlueprintConfiguration("exampleEnvironmentBlueprintConfiguration", EnvironmentBlueprintConfigurationArgs.builder()
 *             .domainId(example.id())
 *             .environmentBlueprintId(defaultDataLake.applyValue(getEnvironmentBlueprintResult -> getEnvironmentBlueprintResult).applyValue(defaultDataLake -> defaultDataLake.applyValue(getEnvironmentBlueprintResult -> getEnvironmentBlueprintResult.id())))
 *             .enabledRegions("us-east-1")
 *             .regionalParameters(Map.of("us-east-1", Map.of("s3Location", "s3://my-amazon-datazone-bucket")))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:datazone:Domain
 *     properties:
 *       name: example_domain
 *       domainExecutionRole: ${domainExecutionRole.arn}
 *   exampleEnvironmentBlueprintConfiguration:
 *     type: aws:datazone:EnvironmentBlueprintConfiguration
 *     name: example
 *     properties:
 *       domainId: ${example.id}
 *       environmentBlueprintId: ${defaultDataLake.id}
 *       enabledRegions:
 *         - us-east-1
 *       regionalParameters:
 *         us-east-1:
 *           s3Location: s3://my-amazon-datazone-bucket
 * variables:
 *   defaultDataLake:
 *     fn::invoke:
 *       Function: aws:datazone:getEnvironmentBlueprint
 *       Arguments:
 *         domainId: ${example.id}
 *         name: DefaultDataLake
 *         managed: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DataZone Environment Blueprint Configuration using the `domain_id` and `environment_blueprint_id`, separated by a `/`. For example:
 * ```sh
 * $ pulumi import aws:datazone/environmentBlueprintConfiguration:EnvironmentBlueprintConfiguration example domain-id-12345/environment-blueprint-id-54321
 * ```
 * @property domainId ID of the Domain.
 * @property enabledRegions Regions in which the blueprint is enabled
 * The following arguments are optional:
 * @property environmentBlueprintId ID of the Environment Blueprint
 * @property manageAccessRoleArn ARN of the manage access role with which this blueprint is created.
 * @property provisioningRoleArn ARN of the provisioning role with which this blueprint is created.
 * @property regionalParameters Parameters for each region in which the blueprint is enabled
 */
public data class EnvironmentBlueprintConfigurationArgs(
    public val domainId: Output<String>? = null,
    public val enabledRegions: Output<List<String>>? = null,
    public val environmentBlueprintId: Output<String>? = null,
    public val manageAccessRoleArn: Output<String>? = null,
    public val provisioningRoleArn: Output<String>? = null,
    public val regionalParameters: Output<Map<String, Map<String, String>>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datazone.EnvironmentBlueprintConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.datazone.EnvironmentBlueprintConfigurationArgs =
        com.pulumi.aws.datazone.EnvironmentBlueprintConfigurationArgs.builder()
            .domainId(domainId?.applyValue({ args0 -> args0 }))
            .enabledRegions(enabledRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .environmentBlueprintId(environmentBlueprintId?.applyValue({ args0 -> args0 }))
            .manageAccessRoleArn(manageAccessRoleArn?.applyValue({ args0 -> args0 }))
            .provisioningRoleArn(provisioningRoleArn?.applyValue({ args0 -> args0 }))
            .regionalParameters(
                regionalParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0.key.to(args0.value)
                            }).toMap(),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnvironmentBlueprintConfigurationArgs].
 */
@PulumiTagMarker
public class EnvironmentBlueprintConfigurationArgsBuilder internal constructor() {
    private var domainId: Output<String>? = null

    private var enabledRegions: Output<List<String>>? = null

    private var environmentBlueprintId: Output<String>? = null

    private var manageAccessRoleArn: Output<String>? = null

    private var provisioningRoleArn: Output<String>? = null

    private var regionalParameters: Output<Map<String, Map<String, String>>>? = null

    /**
     * @param value ID of the Domain.
     */
    @JvmName("ulokxnnixgftifyf")
    public suspend fun domainId(`value`: Output<String>) {
        this.domainId = value
    }

    /**
     * @param value Regions in which the blueprint is enabled
     * The following arguments are optional:
     */
    @JvmName("dkeoyobdgmhugujs")
    public suspend fun enabledRegions(`value`: Output<List<String>>) {
        this.enabledRegions = value
    }

    @JvmName("kltnasdkplxvjyqo")
    public suspend fun enabledRegions(vararg values: Output<String>) {
        this.enabledRegions = Output.all(values.asList())
    }

    /**
     * @param values Regions in which the blueprint is enabled
     * The following arguments are optional:
     */
    @JvmName("lyoggvbowbskgthy")
    public suspend fun enabledRegions(values: List<Output<String>>) {
        this.enabledRegions = Output.all(values)
    }

    /**
     * @param value ID of the Environment Blueprint
     */
    @JvmName("priaxbrmyndspgfs")
    public suspend fun environmentBlueprintId(`value`: Output<String>) {
        this.environmentBlueprintId = value
    }

    /**
     * @param value ARN of the manage access role with which this blueprint is created.
     */
    @JvmName("oagnucrllvwmbric")
    public suspend fun manageAccessRoleArn(`value`: Output<String>) {
        this.manageAccessRoleArn = value
    }

    /**
     * @param value ARN of the provisioning role with which this blueprint is created.
     */
    @JvmName("abcqcbucyykqwtti")
    public suspend fun provisioningRoleArn(`value`: Output<String>) {
        this.provisioningRoleArn = value
    }

    /**
     * @param value Parameters for each region in which the blueprint is enabled
     */
    @JvmName("odeopocqmxtbrudh")
    public suspend fun regionalParameters(`value`: Output<Map<String, Map<String, String>>>) {
        this.regionalParameters = value
    }

    /**
     * @param value ID of the Domain.
     */
    @JvmName("xyxkoxqhgvnlvorv")
    public suspend fun domainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainId = mapped
    }

    /**
     * @param value Regions in which the blueprint is enabled
     * The following arguments are optional:
     */
    @JvmName("utpddqcnyrpioknc")
    public suspend fun enabledRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledRegions = mapped
    }

    /**
     * @param values Regions in which the blueprint is enabled
     * The following arguments are optional:
     */
    @JvmName("mcfsfiupteftlolr")
    public suspend fun enabledRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledRegions = mapped
    }

    /**
     * @param value ID of the Environment Blueprint
     */
    @JvmName("ovncqukmyfbovucx")
    public suspend fun environmentBlueprintId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentBlueprintId = mapped
    }

    /**
     * @param value ARN of the manage access role with which this blueprint is created.
     */
    @JvmName("rtxdotuvyrcvocnn")
    public suspend fun manageAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manageAccessRoleArn = mapped
    }

    /**
     * @param value ARN of the provisioning role with which this blueprint is created.
     */
    @JvmName("biooehyfwrutjsrq")
    public suspend fun provisioningRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningRoleArn = mapped
    }

    /**
     * @param value Parameters for each region in which the blueprint is enabled
     */
    @JvmName("dbhrdbubyuhapdya")
    public suspend fun regionalParameters(`value`: Map<String, Map<String, String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalParameters = mapped
    }

    /**
     * @param values Parameters for each region in which the blueprint is enabled
     */
    @JvmName("lywlthvyurdadnyv")
    public fun regionalParameters(vararg values: Pair<String, Map<String, String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalParameters = mapped
    }

    internal fun build(): EnvironmentBlueprintConfigurationArgs =
        EnvironmentBlueprintConfigurationArgs(
            domainId = domainId,
            enabledRegions = enabledRegions,
            environmentBlueprintId = environmentBlueprintId,
            manageAccessRoleArn = manageAccessRoleArn,
            provisioningRoleArn = provisioningRoleArn,
            regionalParameters = regionalParameters,
        )
}
