@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin

import com.pulumi.aws.datazone.kotlin.outputs.ProjectFailureReason
import com.pulumi.aws.datazone.kotlin.outputs.ProjectTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.datazone.kotlin.outputs.ProjectFailureReason.Companion.toKotlin as projectFailureReasonToKotlin
import com.pulumi.aws.datazone.kotlin.outputs.ProjectTimeouts.Companion.toKotlin as projectTimeoutsToKotlin

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.aws.datazone.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS DataZone Project.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:datazone:Project
 *     properties:
 *       domainId: ${testAwsDatazoneDomain.id}
 *       glossaryTerms:
 *         - 2N8w6XJCwZf
 *       name: name
 *       description: desc
 *       skipDeletionCheck: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.datazone.Project("test", {
 *     domainIdentifier: testAwsDatazoneDomain.id,
 *     name: "name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.datazone.Project("test",
 *     domain_identifier=test_aws_datazone_domain["id"],
 *     name="name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.DataZone.Project("test", new()
 *     {
 *         DomainIdentifier = testAwsDatazoneDomain.Id,
 *         Name = "name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datazone"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datazone.NewProject(ctx, "test", &datazone.ProjectArgs{
 * 			DomainIdentifier: pulumi.Any(testAwsDatazoneDomain.Id),
 * 			Name:             pulumi.String("name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datazone.Project;
 * import com.pulumi.aws.datazone.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Project("test", ProjectArgs.builder()
 *             .domainIdentifier(testAwsDatazoneDomain.id())
 *             .name("name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:datazone:Project
 *     properties:
 *       domainIdentifier: ${testAwsDatazoneDomain.id}
 *       name: name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DataZone Project using the `id`. For example:
 * ```sh
 * $ pulumi import aws:datazone/project:Project example projectid123
 * ```
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.aws.datazone.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * Timestamp of when the project was made.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Creator of the project.
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * Description of project.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of domain which the project is part of. Must follow the regex of ^dzd[-_][a-zA-Z0-9_-]{1,36}$.
     */
    public val domainIdentifier: Output<String>
        get() = javaResource.domainIdentifier().applyValue({ args0 -> args0 })

    /**
     * List of error messages if operation cannot be completed.
     */
    public val failureReasons: Output<List<ProjectFailureReason>>
        get() = javaResource.failureReasons().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> projectFailureReasonToKotlin(args0) })
            })
        })

    /**
     * List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of [a-zA-Z0-9_-]{1,36}$.
     */
    public val glossaryTerms: Output<List<String>>?
        get() = javaResource.glossaryTerms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Timestamp of when the project was last updated.
     */
    public val lastUpdatedAt: Output<String>
        get() = javaResource.lastUpdatedAt().applyValue({ args0 -> args0 })

    /**
     * Name of the project. Must follow the regex of ^[\w -]+$. and have a length of at most 64.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Enum that conveys state of project. Can be ACTIVE, DELETING, or DELETE_FAILED.
     */
    public val projectStatus: Output<String>
        get() = javaResource.projectStatus().applyValue({ args0 -> args0 })

    /**
     * Optional flag to delete all child entities within the project.
     */
    public val skipDeletionCheck: Output<Boolean>?
        get() = javaResource.skipDeletionCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val timeouts: Output<ProjectTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.datazone.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.aws.datazone.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
