@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin

import com.pulumi.aws.datazone.ProjectArgs.builder
import com.pulumi.aws.datazone.kotlin.inputs.ProjectTimeoutsArgs
import com.pulumi.aws.datazone.kotlin.inputs.ProjectTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS DataZone Project.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:datazone:Project
 *     properties:
 *       domainId: ${testAwsDatazoneDomain.id}
 *       glossaryTerms:
 *         - 2N8w6XJCwZf
 *       name: name
 *       description: desc
 *       skipDeletionCheck: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.datazone.Project("test", {
 *     domainIdentifier: testAwsDatazoneDomain.id,
 *     name: "name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.datazone.Project("test",
 *     domain_identifier=test_aws_datazone_domain["id"],
 *     name="name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.DataZone.Project("test", new()
 *     {
 *         DomainIdentifier = testAwsDatazoneDomain.Id,
 *         Name = "name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datazone"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datazone.NewProject(ctx, "test", &datazone.ProjectArgs{
 * 			DomainIdentifier: pulumi.Any(testAwsDatazoneDomain.Id),
 * 			Name:             pulumi.String("name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datazone.Project;
 * import com.pulumi.aws.datazone.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Project("test", ProjectArgs.builder()
 *             .domainIdentifier(testAwsDatazoneDomain.id())
 *             .name("name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:datazone:Project
 *     properties:
 *       domainIdentifier: ${testAwsDatazoneDomain.id}
 *       name: name
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DataZone Project using the `id`. For example:
 * ```sh
 * $ pulumi import aws:datazone/project:Project example projectid123
 * ```
 * @property description Description of project.
 * @property domainIdentifier Identifier of domain which the project is part of. Must follow the regex of ^dzd[-_][a-zA-Z0-9_-]{1,36}$.
 * @property glossaryTerms List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of [a-zA-Z0-9_-]{1,36}$.
 * @property name Name of the project. Must follow the regex of ^[\w -]+$. and have a length of at most 64.
 * The following arguments are optional:
 * @property skipDeletionCheck Optional flag to delete all child entities within the project.
 * @property timeouts
 */
public data class ProjectArgs(
    public val description: Output<String>? = null,
    public val domainIdentifier: Output<String>? = null,
    public val glossaryTerms: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val skipDeletionCheck: Output<Boolean>? = null,
    public val timeouts: Output<ProjectTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.datazone.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.datazone.ProjectArgs =
        com.pulumi.aws.datazone.ProjectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .domainIdentifier(domainIdentifier?.applyValue({ args0 -> args0 }))
            .glossaryTerms(glossaryTerms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .skipDeletionCheck(skipDeletionCheck?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var domainIdentifier: Output<String>? = null

    private var glossaryTerms: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var skipDeletionCheck: Output<Boolean>? = null

    private var timeouts: Output<ProjectTimeoutsArgs>? = null

    /**
     * @param value Description of project.
     */
    @JvmName("egvqkbxqkmstcgqf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Identifier of domain which the project is part of. Must follow the regex of ^dzd[-_][a-zA-Z0-9_-]{1,36}$.
     */
    @JvmName("rpgputxsypvvojtb")
    public suspend fun domainIdentifier(`value`: Output<String>) {
        this.domainIdentifier = value
    }

    /**
     * @param value List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of [a-zA-Z0-9_-]{1,36}$.
     */
    @JvmName("uramckknhfqfldsa")
    public suspend fun glossaryTerms(`value`: Output<List<String>>) {
        this.glossaryTerms = value
    }

    @JvmName("xqioflcwvijwtsku")
    public suspend fun glossaryTerms(vararg values: Output<String>) {
        this.glossaryTerms = Output.all(values.asList())
    }

    /**
     * @param values List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of [a-zA-Z0-9_-]{1,36}$.
     */
    @JvmName("auhkpkpfdfoysxqk")
    public suspend fun glossaryTerms(values: List<Output<String>>) {
        this.glossaryTerms = Output.all(values)
    }

    /**
     * @param value Name of the project. Must follow the regex of ^[\w -]+$. and have a length of at most 64.
     * The following arguments are optional:
     */
    @JvmName("hhvudgqdkyqsnfgy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Optional flag to delete all child entities within the project.
     */
    @JvmName("wsqulioakiglvnfm")
    public suspend fun skipDeletionCheck(`value`: Output<Boolean>) {
        this.skipDeletionCheck = value
    }

    /**
     * @param value
     */
    @JvmName("ceolkdklslbicmtq")
    public suspend fun timeouts(`value`: Output<ProjectTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Description of project.
     */
    @JvmName("ptsalqyuikwwtywj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Identifier of domain which the project is part of. Must follow the regex of ^dzd[-_][a-zA-Z0-9_-]{1,36}$.
     */
    @JvmName("tfbolebbwqnbfvuu")
    public suspend fun domainIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainIdentifier = mapped
    }

    /**
     * @param value List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of [a-zA-Z0-9_-]{1,36}$.
     */
    @JvmName("tesptyaevnnvncfk")
    public suspend fun glossaryTerms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glossaryTerms = mapped
    }

    /**
     * @param values List of glossary terms that can be used in the project. The list cannot be empty or include over 20 values. Each value must follow the regex of [a-zA-Z0-9_-]{1,36}$.
     */
    @JvmName("kbuccpobkyqguhyi")
    public suspend fun glossaryTerms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.glossaryTerms = mapped
    }

    /**
     * @param value Name of the project. Must follow the regex of ^[\w -]+$. and have a length of at most 64.
     * The following arguments are optional:
     */
    @JvmName("spefwjsolukgepdw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Optional flag to delete all child entities within the project.
     */
    @JvmName("svyfbqqtfjvamftu")
    public suspend fun skipDeletionCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDeletionCheck = mapped
    }

    /**
     * @param value
     */
    @JvmName("qwjlpqsvruyihark")
    public suspend fun timeouts(`value`: ProjectTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mycaouvwtpirbqls")
    public suspend fun timeouts(argument: suspend ProjectTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        description = description,
        domainIdentifier = domainIdentifier,
        glossaryTerms = glossaryTerms,
        name = name,
        skipDeletionCheck = skipDeletionCheck,
        timeouts = timeouts,
    )
}
