@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin.inputs

import com.pulumi.aws.datazone.inputs.DomainSingleSignOnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type
 * @property userAssignment
 */
public data class DomainSingleSignOnArgs(
    public val type: Output<String>? = null,
    public val userAssignment: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datazone.inputs.DomainSingleSignOnArgs> {
    override fun toJava(): com.pulumi.aws.datazone.inputs.DomainSingleSignOnArgs =
        com.pulumi.aws.datazone.inputs.DomainSingleSignOnArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .userAssignment(userAssignment?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainSingleSignOnArgs].
 */
@PulumiTagMarker
public class DomainSingleSignOnArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var userAssignment: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lqgqfktqkbiaamwb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("tmjxpksqkufvdbav")
    public suspend fun userAssignment(`value`: Output<String>) {
        this.userAssignment = value
    }

    /**
     * @param value
     */
    @JvmName("nmjvendixtqypksm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("vwheesoaqerafbqn")
    public suspend fun userAssignment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignment = mapped
    }

    internal fun build(): DomainSingleSignOnArgs = DomainSingleSignOnArgs(
        type = type,
        userAssignment = userAssignment,
    )
}
