@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin.inputs

import com.pulumi.aws.datazone.inputs.GetEnvironmentBlueprintPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnvironmentBlueprint.
 * @property domainId ID of the domain.
 * @property managed Whether the blueprint is managed by Amazon DataZone.
 * @property name Name of the blueprint.
 */
public data class GetEnvironmentBlueprintPlainArgs(
    public val domainId: String,
    public val managed: Boolean,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.datazone.inputs.GetEnvironmentBlueprintPlainArgs> {
    override fun toJava(): com.pulumi.aws.datazone.inputs.GetEnvironmentBlueprintPlainArgs =
        com.pulumi.aws.datazone.inputs.GetEnvironmentBlueprintPlainArgs.builder()
            .domainId(domainId.let({ args0 -> args0 }))
            .managed(managed.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnvironmentBlueprintPlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentBlueprintPlainArgsBuilder internal constructor() {
    private var domainId: String? = null

    private var managed: Boolean? = null

    private var name: String? = null

    /**
     * @param value ID of the domain.
     */
    @JvmName("fgvqqrdpolirmtta")
    public suspend fun domainId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainId = mapped
    }

    /**
     * @param value Whether the blueprint is managed by Amazon DataZone.
     */
    @JvmName("suutmluspdsujmbt")
    public suspend fun managed(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managed = mapped
    }

    /**
     * @param value Name of the blueprint.
     */
    @JvmName("bxxnfgtiviorscsg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetEnvironmentBlueprintPlainArgs = GetEnvironmentBlueprintPlainArgs(
        domainId = domainId ?: throw PulumiNullFieldException("domainId"),
        managed = managed ?: throw PulumiNullFieldException("managed"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
