@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datazone.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEnvironmentBlueprint.
 * @property blueprintProvider Provider of the blueprint
 * @property description Description of the blueprint
 * @property domainId
 * @property id ID of the environment blueprint
 * @property managed
 * @property name
 */
public data class GetEnvironmentBlueprintResult(
    public val blueprintProvider: String,
    public val description: String,
    public val domainId: String,
    public val id: String,
    public val managed: Boolean,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datazone.outputs.GetEnvironmentBlueprintResult): GetEnvironmentBlueprintResult = GetEnvironmentBlueprintResult(
            blueprintProvider = javaType.blueprintProvider(),
            description = javaType.description(),
            domainId = javaType.domainId(),
            id = javaType.id(),
            managed = javaType.managed(),
            name = javaType.name(),
        )
    }
}
