@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin

import com.pulumi.aws.dax.kotlin.outputs.ClusterNode
import com.pulumi.aws.dax.kotlin.outputs.ClusterServerSideEncryption
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.dax.kotlin.outputs.ClusterNode.Companion.toKotlin as clusterNodeToKotlin
import com.pulumi.aws.dax.kotlin.outputs.ClusterServerSideEncryption.Companion.toKotlin as clusterServerSideEncryptionToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.dax.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides a DAX Cluster resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.dax.Cluster("bar", {
 *     clusterName: "cluster-example",
 *     iamRoleArn: example.arn,
 *     nodeType: "dax.r4.large",
 *     replicationFactor: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.dax.Cluster("bar",
 *     cluster_name="cluster-example",
 *     iam_role_arn=example["arn"],
 *     node_type="dax.r4.large",
 *     replication_factor=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.Dax.Cluster("bar", new()
 *     {
 *         ClusterName = "cluster-example",
 *         IamRoleArn = example.Arn,
 *         NodeType = "dax.r4.large",
 *         ReplicationFactor = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dax"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dax.NewCluster(ctx, "bar", &dax.ClusterArgs{
 * 			ClusterName:       pulumi.String("cluster-example"),
 * 			IamRoleArn:        pulumi.Any(example.Arn),
 * 			NodeType:          pulumi.String("dax.r4.large"),
 * 			ReplicationFactor: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dax.Cluster;
 * import com.pulumi.aws.dax.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Cluster("bar", ClusterArgs.builder()
 *             .clusterName("cluster-example")
 *             .iamRoleArn(example.arn())
 *             .nodeType("dax.r4.large")
 *             .replicationFactor(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:dax:Cluster
 *     properties:
 *       clusterName: cluster-example
 *       iamRoleArn: ${example.arn}
 *       nodeType: dax.r4.large
 *       replicationFactor: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DAX Clusters using the `cluster_name`. For example:
 * ```sh
 * $ pulumi import aws:dax/cluster:Cluster my_cluster my_cluster
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.dax.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The ARN of the DAX cluster
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of Availability Zones in which the
     * nodes will be created
     */
    public val availabilityZones: Output<List<String>>?
        get() = javaResource.availabilityZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The DNS name of the DAX cluster without the port appended
     */
    public val clusterAddress: Output<String>
        get() = javaResource.clusterAddress().applyValue({ args0 -> args0 })

    /**
     * The type of encryption the
     * cluster's endpoint should support. Valid values are: `NONE` and `TLS`.
     * Default value is `NONE`.
     */
    public val clusterEndpointEncryptionType: Output<String>?
        get() = javaResource.clusterEndpointEncryptionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Group identifier. DAX converts this name to
     * lowercase
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * The configuration endpoint for this DAX cluster,
     * consisting of a DNS name and a port number
     */
    public val configurationEndpoint: Output<String>
        get() = javaResource.configurationEndpoint().applyValue({ args0 -> args0 })

    /**
     * Description for the cluster
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A valid Amazon Resource Name (ARN) that identifies
     * an IAM role. At runtime, DAX will assume this role and use the role's
     * permissions to access DynamoDB on your behalf
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * Specifies the weekly time range for when
     * maintenance on the cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi`
     * (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example:
     * `sun:05:00-sun:09:00`
     */
    public val maintenanceWindow: Output<String>
        get() = javaResource.maintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * The compute and memory capacity of the nodes. See
     * [Nodes](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.concepts.cluster.html#DAX.concepts.nodes) for supported node types
     */
    public val nodeType: Output<String>
        get() = javaResource.nodeType().applyValue({ args0 -> args0 })

    /**
     * List of node objects including `id`, `address`, `port` and
     * `availability_zone`. Referenceable e.g., as
     * `${aws_dax_cluster.test.nodes.0.address}`
     */
    public val nodes: Output<List<ClusterNode>>
        get() = javaResource.nodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterNodeToKotlin(args0)
                })
            })
        })

    /**
     * An Amazon Resource Name (ARN) of an
     * SNS topic to send DAX notifications to. Example:
     * `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
     */
    public val notificationTopicArn: Output<String>?
        get() = javaResource.notificationTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the parameter group to associate
     * with this DAX cluster
     */
    public val parameterGroupName: Output<String>
        get() = javaResource.parameterGroupName().applyValue({ args0 -> args0 })

    /**
     * The port used by the configuration endpoint
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The number of nodes in the DAX cluster. A
     * replication factor of 1 will create a single-node cluster, without any read
     * replicas
     */
    public val replicationFactor: Output<Int>
        get() = javaResource.replicationFactor().applyValue({ args0 -> args0 })

    /**
     * One or more VPC security groups associated
     * with the cluster
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Encrypt at rest options
     */
    public val serverSideEncryption: Output<ClusterServerSideEncryption>?
        get() = javaResource.serverSideEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterServerSideEncryptionToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the subnet group to be used for the
     * cluster
     */
    public val subnetGroupName: Output<String>
        get() = javaResource.subnetGroupName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dax.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.dax.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
