@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin

import com.pulumi.aws.dax.ParameterGroupArgs.builder
import com.pulumi.aws.dax.kotlin.inputs.ParameterGroupParameterArgs
import com.pulumi.aws.dax.kotlin.inputs.ParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DAX Parameter Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dax.ParameterGroup("example", {
 *     name: "example",
 *     parameters: [
 *         {
 *             name: "query-ttl-millis",
 *             value: "100000",
 *         },
 *         {
 *             name: "record-ttl-millis",
 *             value: "100000",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dax.ParameterGroup("example",
 *     name="example",
 *     parameters=[
 *         {
 *             "name": "query-ttl-millis",
 *             "value": "100000",
 *         },
 *         {
 *             "name": "record-ttl-millis",
 *             "value": "100000",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Dax.ParameterGroup("example", new()
 *     {
 *         Name = "example",
 *         Parameters = new[]
 *         {
 *             new Aws.Dax.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "query-ttl-millis",
 *                 Value = "100000",
 *             },
 *             new Aws.Dax.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "record-ttl-millis",
 *                 Value = "100000",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dax"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dax.NewParameterGroup(ctx, "example", &dax.ParameterGroupArgs{
 * 			Name: pulumi.String("example"),
 * 			Parameters: dax.ParameterGroupParameterArray{
 * 				&dax.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("query-ttl-millis"),
 * 					Value: pulumi.String("100000"),
 * 				},
 * 				&dax.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("record-ttl-millis"),
 * 					Value: pulumi.String("100000"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dax.ParameterGroup;
 * import com.pulumi.aws.dax.ParameterGroupArgs;
 * import com.pulumi.aws.dax.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ParameterGroup("example", ParameterGroupArgs.builder()
 *             .name("example")
 *             .parameters(
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("query-ttl-millis")
 *                     .value("100000")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("record-ttl-millis")
 *                     .value("100000")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dax:ParameterGroup
 *     properties:
 *       name: example
 *       parameters:
 *         - name: query-ttl-millis
 *           value: '100000'
 *         - name: record-ttl-millis
 *           value: '100000'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DAX Parameter Group using the `name`. For example:
 * ```sh
 * $ pulumi import aws:dax/parameterGroup:ParameterGroup example my_dax_pg
 * ```
 * @property description A description of the parameter group.
 * @property name The name of the parameter group.
 * @property parameters The parameters of the parameter group.
 */
public data class ParameterGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<List<ParameterGroupParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dax.ParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.dax.ParameterGroupArgs =
        com.pulumi.aws.dax.ParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ParameterGroupArgs].
 */
@PulumiTagMarker
public class ParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ParameterGroupParameterArgs>>? = null

    /**
     * @param value A description of the parameter group.
     */
    @JvmName("qdiqtocpjrayyqdm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the parameter group.
     */
    @JvmName("diaaajwmonyxotof")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters of the parameter group.
     */
    @JvmName("tgjjhcssclvjqfdm")
    public suspend fun parameters(`value`: Output<List<ParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("ctydlqfgurqukjga")
    public suspend fun parameters(vararg values: Output<ParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters of the parameter group.
     */
    @JvmName("mxnskmsdvlksamhe")
    public suspend fun parameters(values: List<Output<ParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A description of the parameter group.
     */
    @JvmName("tspbjhbfgqrnnvji")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the parameter group.
     */
    @JvmName("mfyaiqdnbdkelxhf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters of the parameter group.
     */
    @JvmName("sodyfahoeasiwcpp")
    public suspend fun parameters(`value`: List<ParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the parameter group.
     */
    @JvmName("wnhbqbyfdqcbxnum")
    public suspend fun parameters(argument: List<suspend ParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the parameter group.
     */
    @JvmName("gbifpbcfvnvmbsdl")
    public suspend fun parameters(vararg argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the parameter group.
     */
    @JvmName("ctojnqikifjlexcy")
    public suspend fun parameters(argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters of the parameter group.
     */
    @JvmName("vmotolhdffqfelwt")
    public suspend fun parameters(vararg values: ParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): ParameterGroupArgs = ParameterGroupArgs(
        description = description,
        name = name,
        parameters = parameters,
    )
}
