@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin

import com.pulumi.aws.dax.SubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DAX Subnet Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dax.SubnetGroup("example", {
 *     name: "example",
 *     subnetIds: [
 *         example1.id,
 *         example2.id,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dax.SubnetGroup("example",
 *     name="example",
 *     subnet_ids=[
 *         example1["id"],
 *         example2["id"],
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Dax.SubnetGroup("example", new()
 *     {
 *         Name = "example",
 *         SubnetIds = new[]
 *         {
 *             example1.Id,
 *             example2.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dax"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dax.NewSubnetGroup(ctx, "example", &dax.SubnetGroupArgs{
 * 			Name: pulumi.String("example"),
 * 			SubnetIds: pulumi.StringArray{
 * 				example1.Id,
 * 				example2.Id,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dax.SubnetGroup;
 * import com.pulumi.aws.dax.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubnetGroup("example", SubnetGroupArgs.builder()
 *             .name("example")
 *             .subnetIds(
 *                 example1.id(),
 *                 example2.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dax:SubnetGroup
 *     properties:
 *       name: example
 *       subnetIds:
 *         - ${example1.id}
 *         - ${example2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DAX Subnet Group using the `name`. For example:
 * ```sh
 * $ pulumi import aws:dax/subnetGroup:SubnetGroup example my_dax_sg
 * ```
 * @property description A description of the subnet group.
 * @property name The name of the subnet group.
 * @property subnetIds A list of VPC subnet IDs for the subnet group.
 */
public data class SubnetGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dax.SubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.dax.SubnetGroupArgs =
        com.pulumi.aws.dax.SubnetGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SubnetGroupArgs].
 */
@PulumiTagMarker
public class SubnetGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value A description of the subnet group.
     */
    @JvmName("irvxmkeurshvfwlr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the subnet group.
     */
    @JvmName("dslrfhiuohxeewpq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("cxcmrrqloxsgxpnt")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("mubvbyhovdswvxff")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("iybshtyegdfygema")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A description of the subnet group.
     */
    @JvmName("ecxboancufmtnnav")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the subnet group.
     */
    @JvmName("oguxspfcikljkiya")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("saicnsysgeknmkpa")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("smhbyqkpofdkvnwl")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): SubnetGroupArgs = SubnetGroupArgs(
        description = description,
        name = name,
        subnetIds = subnetIds,
    )
}
